/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseBasedStateProvider;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import potionstudios.byg.common.world.feature.stateproviders.BYGStateProviders;

public class BetweenNoiseThresholdProvider
extends NoiseBasedStateProvider {
    public static final Codec<BetweenNoiseThresholdProvider> CODEC = RecordCodecBuilder.create(builder -> BetweenNoiseThresholdProvider.m_191425_((RecordCodecBuilder.Instance)builder).and(builder.group((App)FloatProvider.f_146502_.listOf().fieldOf("thresholds").forGetter(stateProvider -> stateProvider.thresholds), (App)BlockStateProvider.f_68747_.fieldOf("within_noise_state_provider").forGetter(stateProvider -> stateProvider.withinNoiseStateProvider), (App)BlockStateProvider.f_68747_.fieldOf("outside_noise_state_provider").forGetter(stateProvider -> stateProvider.outsideNoiseStateProvider), (App)Codec.BOOL.fieldOf("use_3d_noise").forGetter(stateprovider -> stateprovider.use3D))).apply((Applicative)builder, BetweenNoiseThresholdProvider::new));
    private final List<FloatProvider> thresholds;
    private final BlockStateProvider withinNoiseStateProvider;
    private final BlockStateProvider outsideNoiseStateProvider;
    private final boolean use3D;

    public BetweenNoiseThresholdProvider(long seed, NormalNoise.NoiseParameters noiseParameters, float scale, List<FloatProvider> thresholds, BlockStateProvider withinNoiseStateProvider, BlockStateProvider outsideNoiseStateProvider, boolean use3D) {
        super(seed, noiseParameters, scale);
        this.thresholds = thresholds;
        this.withinNoiseStateProvider = withinNoiseStateProvider;
        this.outsideNoiseStateProvider = outsideNoiseStateProvider;
        this.use3D = use3D;
    }

    public BlockState m_213972_(RandomSource random, BlockPos pos) {
        double noiseValue = this.use3D ? this.getNoiseValue2D(pos, 4.0) : this.m_191429_(pos, this.f_191419_);
        for (FloatProvider threshold : this.thresholds) {
            if (!(noiseValue >= (double)threshold.m_142735_()) || !(noiseValue <= (double)threshold.m_142734_())) continue;
            return this.withinNoiseStateProvider.m_213972_(random, pos);
        }
        return this.outsideNoiseStateProvider.m_213972_(random, pos);
    }

    protected double getNoiseValue2D(BlockPos $$0, double $$1) {
        return this.f_191420_.m_75380_((double)$$0.m_123341_() * $$1, 0.0, (double)$$0.m_123343_() * $$1);
    }

    protected BlockStateProviderType<?> m_5923_() {
        return BYGStateProviders.BETWEEN_NOISE_THRESHOLD_PROVIDER.get();
    }

    public static List<FloatProvider> createThresholds(float size, float min, float max) {
        ArrayList<FloatProvider> thresholds = new ArrayList<FloatProvider>();
        for (float start = min; start <= max; start += size * 2.0f) {
            thresholds.add((FloatProvider)UniformFloat.m_146605_((float)start, (float)(start + size)));
        }
        return thresholds;
    }
}

