/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import potionstudios.byg.util.MLBlockTags;

public class BlockHelper {
    public static final BooleanProperty ROOTS = BooleanProperty.m_61465_((String)"roots");
    public static final int FLAG_UPDATE_BLOCK = 1;
    public static final int FLAG_SEND_CLIENT_CHANGES = 2;
    public static final int FLAG_NO_RERENDER = 4;
    public static final int FORSE_RERENDER = 8;
    public static final int FLAG_IGNORE_OBSERVERS = 16;
    public static final int SET_SILENT = 19;
    public static final int SET_OBSERV = 3;
    public static final Direction[] HORIZONTAL_DIRECTIONS = BlockHelper.makeHorizontal();
    public static final Direction[] DIRECTIONS = Direction.values();
    private static final BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
    protected static final BlockState AIR = Blocks.f_50016_.m_49966_();
    protected static final BlockState WATER = Blocks.f_49990_.m_49966_();

    public static int upRay(LevelReader world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.m_46859_(pos.m_6630_(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRay(LevelReader world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.m_46859_(pos.m_6625_(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRayRep(LevelReader world, BlockPos pos, int maxDist) {
        POS.m_122190_((Vec3i)pos);
        for (int j = 1; j < maxDist && world.m_8055_((BlockPos)POS).m_60767_().m_76336_(); ++j) {
            POS.m_142448_(POS.m_123342_() - 1);
        }
        return pos.m_123342_() - POS.m_123342_();
    }

    public static Direction[] makeHorizontal() {
        return new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    }

    public static Direction randomHorizontal(Random random) {
        return HORIZONTAL_DIRECTIONS[random.nextInt(4)];
    }

    public static Direction randomDirection(Random random) {
        return DIRECTIONS[random.nextInt(6)];
    }

    public static BlockState rotateHorizontal(BlockState state, Rotation rotation, DirectionProperty facing) {
        return (BlockState)state.m_61124_((Property)facing, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)facing)));
    }

    public static BlockState mirrorHorizontal(BlockState state, Mirror mirror, DirectionProperty facing) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)facing)));
    }

    public static Direction getRandomHorizontalDirection(Random rand) {
        return HORIZONTAL_DIRECTIONS[rand.nextInt(4)];
    }

    public static void setWithoutUpdate(LevelWriter world, BlockPos pos, BlockState state) {
        world.m_7731_(pos, state, 19);
    }

    public static void setWithUpdate(LevelWriter world, BlockPos pos, BlockState state) {
        world.m_7731_(pos, state, 3);
    }

    public static void setWithUpdate(LevelWriter world, BlockPos pos, Block block) {
        world.m_7731_(pos, block.m_49966_(), 3);
    }

    public static void setWithoutUpdate(LevelWriter world, BlockPos pos, Block block) {
        world.m_7731_(pos, block.m_49966_(), 19);
    }

    public static void fixBlocks(LevelAccessor world, BlockPos start, BlockPos end) {
        HashSet doubleCheck = Sets.newHashSet();
        for (int x = start.m_123341_(); x <= end.m_123341_(); ++x) {
            POS.m_142451_(x);
            for (int z = start.m_123343_(); z <= end.m_123343_(); ++z) {
                POS.m_142443_(z);
                block2: for (int y = start.m_123342_(); y <= end.m_123342_(); ++y) {
                    POS.m_142448_(y);
                    BlockState state = world.m_8055_((BlockPos)POS);
                    if (!state.m_60819_().m_76178_()) {
                        if (!state.m_60710_((LevelReader)world, (BlockPos)POS)) {
                            BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, WATER);
                            POS.m_142448_(POS.m_123342_() - 1);
                            state = world.m_8055_((BlockPos)POS);
                            while (!state.m_60710_((LevelReader)world, (BlockPos)POS)) {
                                state = state.m_60819_().m_76178_() ? AIR : WATER;
                                BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, state);
                                POS.m_142448_(POS.m_123342_() - 1);
                                state = world.m_8055_((BlockPos)POS);
                            }
                        }
                        POS.m_142448_(y - 1);
                        if (world.m_46859_((BlockPos)POS)) {
                            POS.m_142448_(y);
                            while (!world.m_6425_((BlockPos)POS).m_76178_()) {
                                BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, AIR);
                                POS.m_142448_(POS.m_123342_() + 1);
                            }
                            continue;
                        }
                        for (Direction dir : HORIZONTAL_DIRECTIONS) {
                            if (!world.m_46859_(POS.m_121945_(dir))) continue;
                            world.m_186469_((BlockPos)POS, state.m_60819_().m_76152_(), 0);
                            continue block2;
                        }
                        continue;
                    }
                    if (state.m_60710_((LevelReader)world, (BlockPos)POS)) continue;
                    if (state.m_60713_(Blocks.f_50490_)) {
                        HashSet ends = Sets.newHashSet();
                        HashSet add = Sets.newHashSet();
                        ends.add(POS.m_7949_());
                        for (int i = 0; i < 64 && !ends.isEmpty(); ++i) {
                            ends.forEach(pos -> {
                                BlockHelper.setWithoutUpdate((LevelWriter)world, pos, AIR);
                                for (Direction dir : HORIZONTAL_DIRECTIONS) {
                                    BlockPos p = pos.m_121945_(dir);
                                    BlockState st = world.m_8055_(p);
                                    if (!st.m_60713_(Blocks.f_50490_) && !st.m_60713_(Blocks.f_50491_) || st.m_60710_((LevelReader)world, p)) continue;
                                    add.add(p);
                                }
                                BlockPos p = pos.m_7494_();
                                BlockState st = world.m_8055_(p);
                                if ((st.m_60713_(Blocks.f_50490_) || st.m_60713_(Blocks.f_50491_)) && !st.m_60710_((LevelReader)world, p)) {
                                    add.add(p);
                                }
                            });
                            ends.clear();
                            ends.addAll(add);
                            add.clear();
                        }
                        continue;
                    }
                    if (state.m_60734_() instanceof VineBlock) {
                        while (world.m_8055_((BlockPos)POS).m_60734_() instanceof VineBlock) {
                            BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, AIR);
                            POS.m_142448_(POS.m_123342_() - 1);
                        }
                        continue;
                    }
                    if (!(state.m_60734_() instanceof FallingBlock)) continue;
                    BlockState falling = state;
                    POS.m_142448_(POS.m_123342_() - 1);
                    state = world.m_8055_((BlockPos)POS);
                    int ray = BlockHelper.downRayRep((LevelReader)world, POS.m_7949_(), 64);
                    if (ray > 32) {
                        BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, Blocks.f_50259_.m_49966_());
                        if (!world.m_213780_().m_188499_()) continue;
                        POS.m_142448_(POS.m_123342_() - 1);
                        state = world.m_8055_((BlockPos)POS);
                        BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, Blocks.f_50259_.m_49966_());
                        continue;
                    }
                    POS.m_142448_(y);
                    BlockState replacement = AIR;
                    for (Direction dir : HORIZONTAL_DIRECTIONS) {
                        state = world.m_8055_(POS.m_121945_(dir));
                        if (state.m_60819_().m_76178_()) continue;
                        replacement = state;
                        break;
                    }
                    BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, replacement);
                    POS.m_142448_(y - ray);
                    BlockHelper.setWithoutUpdate((LevelWriter)world, (BlockPos)POS, falling);
                }
            }
        }
        doubleCheck.forEach(pos -> {
            if (!world.m_8055_(pos).m_60710_((LevelReader)world, pos)) {
                BlockHelper.setWithoutUpdate((LevelWriter)world, pos, AIR);
            }
        });
    }

    private static BlockState getAirOrFluid(BlockState state) {
        return state.m_60819_().m_76178_() ? AIR : state.m_60819_().m_76188_();
    }

    public static boolean isEndNylium(BlockState state) {
        return state.m_204336_(BlockTags.f_13077_) && state.m_204336_(MLBlockTags.END_STONES);
    }
}

