/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.datagen.ext;

import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.SingleWorldGenData;
import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.WorldGenData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockAgeProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.NopProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;

public class StructureProcessorData
extends SingleWorldGenData<StructureProcessorList> {
    public StructureProcessorData(WorldGenData.Properties properties) {
        super(properties, Registry.f_122883_, StructureProcessorType.f_74467_);
    }

    public ProcessorListBuilder processor() {
        return new ProcessorListBuilder();
    }

    public static ProcessorRuleBuilder rule(Block block) {
        return StructureProcessorData.rule(block.m_49966_());
    }

    public static ProcessorRuleBuilder rule(Block block, CompoundTag nbt) {
        return StructureProcessorData.rule(block.m_49966_(), nbt);
    }

    public static ProcessorRuleBuilder rule(BlockState state) {
        return new ProcessorRuleBuilder(state, null);
    }

    public static ProcessorRuleBuilder rule(BlockState state, CompoundTag nbt) {
        return new ProcessorRuleBuilder(state, nbt);
    }

    public class ProcessorListBuilder {
        private final List<StructureProcessor> processors = new ArrayList<StructureProcessor>();
        private final List<ProcessorRule> rules = new ArrayList<ProcessorRule>();

        private ProcessorListBuilder() {
        }

        public ProcessorListBuilder jigsaw() {
            return this.add(new StructureProcessor[]{JigsawReplacementProcessor.f_74122_});
        }

        public ProcessorListBuilder keep(TagKey<Block> protectedBlocks) {
            return this.add(new StructureProcessor[]{new ProtectedBlockProcessor(protectedBlocks)});
        }

        public ProcessorListBuilder ignore(List<Block> ignoredBlocks) {
            return this.add(new StructureProcessor[]{new BlockIgnoreProcessor(List.copyOf(ignoredBlocks))});
        }

        public ProcessorListBuilder age(float mossProbability) {
            return this.add(new StructureProcessor[]{new BlockAgeProcessor(mossProbability)});
        }

        public ProcessorListBuilder addRule(ProcessorRule ... rules) {
            this.rules.addAll(Arrays.asList(rules));
            return this;
        }

        public ProcessorListBuilder addRules(Collection<ProcessorRule> rules) {
            this.rules.addAll(rules);
            return this;
        }

        public ProcessorListBuilder add(StructureProcessor ... processors) {
            this.rulesToProcessor();
            this.processors.addAll(Arrays.asList(processors));
            return this;
        }

        public ProcessorListBuilder addAll(Collection<StructureProcessor> processors) {
            this.rulesToProcessor();
            this.processors.addAll(processors);
            return this;
        }

        private void rulesToProcessor() {
            if (!this.rules.isEmpty()) {
                this.processors.add((StructureProcessor)new RuleProcessor(List.copyOf(this.rules)));
                this.rules.clear();
            }
        }

        public Holder<StructureProcessorList> build() {
            this.rulesToProcessor();
            if (this.processors.isEmpty()) {
                this.add(new StructureProcessor[]{NopProcessor.f_74175_});
            }
            return StructureProcessorData.this.addToList(StructureProcessorData.this.registries.holder(Registry.f_122883_, new StructureProcessorList(List.copyOf(this.processors))));
        }
    }

    public static class ProcessorRuleBuilder {
        private final BlockState output;
        private final CompoundTag outputNbt;
        private RuleTest templateState;
        private RuleTest worldState;
        private PosRuleTest location;

        private ProcessorRuleBuilder(BlockState output, @Nullable CompoundTag outputNbt) {
            this.output = output;
            this.outputNbt = outputNbt == null ? null : outputNbt.m_6426_();
            this.templateState = AlwaysTrueTest.f_73954_;
            this.worldState = AlwaysTrueTest.f_73954_;
            this.location = PosAlwaysTrueTest.f_74188_;
        }

        public ProcessorRuleBuilder templateStateTest(RuleTest templateState) {
            this.templateState = templateState;
            return this;
        }

        public ProcessorRuleBuilder worldStateTest(RuleTest worldState) {
            this.worldState = worldState;
            return this;
        }

        public ProcessorRuleBuilder locationTest(PosRuleTest location) {
            this.location = location;
            return this;
        }

        public ProcessorRule build() {
            return new ProcessorRule(this.templateState, this.worldState, this.location, this.output, Optional.ofNullable(this.outputNbt));
        }
    }
}

