/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.surface;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.noeppi_noeppi.mods.sandbox.SandBox;
import io.github.noeppi_noeppi.mods.sandbox.surface.BiomeSurface;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;

public record SurfaceRuleSet(boolean defaultNoiseSurface, SurfaceRules.RuleSource beforeBiomes, SurfaceRules.RuleSource afterBiomes, SurfaceRules.RuleSource defaultBiomeSurface) {
    public static final Codec<SurfaceRuleSet> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("default_noise_surface").orElse((Object)false).forGetter(SurfaceRuleSet::defaultNoiseSurface), (App)SurfaceRules.RuleSource.f_189682_.fieldOf("before_biomes").forGetter(SurfaceRuleSet::beforeBiomes), (App)SurfaceRules.RuleSource.f_189682_.fieldOf("after_biomes").forGetter(SurfaceRuleSet::afterBiomes), (App)SurfaceRules.RuleSource.f_189682_.fieldOf("default_biome_surface").forGetter(SurfaceRuleSet::defaultBiomeSurface)).apply((Applicative)instance, SurfaceRuleSet::new));
    public static final Codec<Holder<SurfaceRuleSet>> CODEC = RegistryFileCodec.m_135589_(SandBox.SURFACE_RULE_SET_REGISTRY, DIRECT_CODEC);

    public SurfaceRules.RuleSource build(Registry<Biome> biomeRegistry, Registry<BiomeSurface> surfaceRegistry, Set<Holder<Biome>> biomes, NoiseGeneratorSettings settings) {
        ArrayList<SurfaceRules.RuleSource> rules = new ArrayList<SurfaceRules.RuleSource>();
        rules.add(this.beforeBiomes());
        ArrayList<ResourceKey> biomesWithRules = new ArrayList<ResourceKey>();
        for (Holder<Biome> biome : biomes) {
            ResourceKey biomeKey;
            BiomeSurface biomeSurface;
            ResourceLocation id;
            if ((id = (switch (biome.m_203376_()) {
                default -> throw new IncompatibleClassChangeError();
                case Holder.Kind.REFERENCE -> ((Holder.Reference)biome).m_205785_().m_135782_();
                case Holder.Kind.DIRECT -> biomeRegistry.m_7981_((Object)((Biome)biome.m_203334_()));
            })) == null || (biomeSurface = (BiomeSurface)surfaceRegistry.m_7745_(id)) == null || biomesWithRules.contains(biomeKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)id))) continue;
            biomesWithRules.add(biomeKey);
            rules.add(SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)biomeSurface.rule()));
        }
        if (biomesWithRules.isEmpty()) {
            rules.add(this.defaultBiomeSurface());
        } else {
            rules.add(SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])((ResourceKey[])biomesWithRules.toArray(ResourceKey[]::new)))), (SurfaceRules.RuleSource)this.defaultBiomeSurface()));
        }
        rules.add(this.afterBiomes());
        if (this.defaultNoiseSurface()) {
            rules.add(settings.f_188871_());
        }
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])rules.toArray(SurfaceRules.RuleSource[]::new)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }
}

