/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui;

public class IndentationUtils {
    private static int findLineStart(String content, int cursorPos) {
        while (cursorPos > 0 && content.charAt(cursorPos - 1) != '\n') {
            --cursorPos;
        }
        return cursorPos;
    }

    private static int findLineEnd(String content, int cursorPos) {
        while (cursorPos < content.length() && content.charAt(cursorPos) != '\n') {
            ++cursorPos;
        }
        return cursorPos;
    }

    public static IndentationResult indent(String content, int cursorPos, int selectionCursorPos) {
        int lineEnd;
        StringBuilder sb = new StringBuilder(content);
        int lineStart = IndentationUtils.findLineStart(content, Math.min(cursorPos, selectionCursorPos));
        if (lineStart == (lineEnd = IndentationUtils.findLineEnd(content, Math.max(cursorPos, selectionCursorPos)))) {
            sb.insert(lineStart, "    ");
            if (lineStart <= cursorPos) {
                cursorPos += 4;
            }
            if (lineStart <= selectionCursorPos) {
                selectionCursorPos += 4;
            }
        } else {
            while (lineStart < lineEnd) {
                sb.insert(lineStart, "    ");
                lineEnd += 4;
                if (lineStart < cursorPos) {
                    cursorPos += 4;
                }
                if (lineStart < selectionCursorPos) {
                    selectionCursorPos += 4;
                }
                lineStart = IndentationUtils.findLineEnd(sb.toString(), lineStart) + 1;
            }
        }
        return new IndentationResult(sb.toString(), cursorPos, selectionCursorPos);
    }

    public static IndentationResult deindent(String content, int cursorPos, int selectionCursorPos) {
        StringBuilder sb = new StringBuilder(content);
        int lineStart = IndentationUtils.findLineStart(content, Math.min(cursorPos, selectionCursorPos));
        int lineEnd = IndentationUtils.findLineEnd(content, Math.max(cursorPos, selectionCursorPos));
        while (lineStart < lineEnd) {
            for (int i = 0; i < 4 && lineStart < sb.length() && sb.charAt(lineStart) == ' '; ++i) {
                sb.deleteCharAt(lineStart);
                --lineEnd;
                if (lineStart < cursorPos) {
                    --cursorPos;
                }
                if (lineStart >= selectionCursorPos) continue;
                --selectionCursorPos;
            }
            lineStart = IndentationUtils.findLineEnd(sb.toString(), lineStart) + 1;
        }
        return new IndentationResult(sb.toString(), cursorPos, selectionCursorPos);
    }

    public record IndentationResult(String content, int cursorPosition, int selectionCursorPosition) {
    }
}

