/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="sfm")
public class OpenContainerTracker {
    private static final Map<ServerPlayer, AbstractContainerMenu> OPEN_CONTAINERS = new WeakHashMap<ServerPlayer, AbstractContainerMenu>();

    public static <T extends AbstractContainerMenu> Stream<Map.Entry<ServerPlayer, T>> getPlayersWithOpenContainer(Class<T> menuClass) {
        return OPEN_CONTAINERS.entrySet().stream().filter(e -> menuClass.isInstance(e.getValue())).map(e -> e);
    }

    @SubscribeEvent
    public static void onOpenContainer(PlayerContainerEvent.Open event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            OPEN_CONTAINERS.put(serverPlayer, event.getContainer());
        }
    }

    @SubscribeEvent
    public static void onCloseContainer(PlayerContainerEvent.Close event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            OPEN_CONTAINERS.remove(serverPlayer);
        }
    }
}

