/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import quek.undergarden.entity.UGBoat;

public class UGBoatRenderer
extends EntityRenderer<UGBoat> {
    private final Map<UGBoat.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public UGBoatRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(UGBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("undergarden", UGBoatRenderer.getTextureLocation(type, chest)), (Object)this.createBoatModel(context, (UGBoat.Type)((Object)type), chest))));
    }

    private static ModelLayerLocation createLocation(String path, String model) {
        return new ModelLayerLocation(new ResourceLocation("undergarden", path), model);
    }

    public static ModelLayerLocation createBoatModelName(UGBoat.Type pType) {
        return UGBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(UGBoat.Type type) {
        return UGBoatRenderer.createLocation("chest_boat/" + type.getName(), "main");
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, UGBoat.Type type, boolean chest) {
        ModelLayerLocation modellayerlocation = chest ? UGBoatRenderer.createChestBoatModelName(type) : UGBoatRenderer.createBoatModelName(type);
        return new BoatModel(context.m_174023_(modellayerlocation), chest);
    }

    private static String getTextureLocation(UGBoat.Type type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(UGBoat entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float bubbleAngle;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.375, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        float f = (float)entity.m_38385_() - partialTicks;
        float f1 = entity.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(bubbleAngle = entity.m_38352_(partialTicks)), (float)0.0f)) {
            poseStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entity.m_38352_(partialTicks), true));
        }
        Pair<ResourceLocation, BoatModel> boatResources = this.boatResources.get((Object)entity.getUGBoatType());
        ResourceLocation texture = (ResourceLocation)boatResources.getFirst();
        BoatModel boat = (BoatModel)boatResources.getSecond();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        boat.m_6973_((Boat)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(boat.m_103119_(texture));
        boat.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer vertexconsumer1 = bufferSource.m_6299_(RenderType.m_110478_());
            boat.m_102282_().m_104301_(poseStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(UGBoat entity) {
        return (ResourceLocation)this.boatResources.get((Object)entity.getUGBoatType()).getFirst();
    }
}

