/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.IForgeShearable;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class Mog
extends Animal
implements IForgeShearable {
    private static final EntityDataAccessor<Boolean> HAS_MOSS = SynchedEntityData.m_135353_(Mog.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int timeWithoutMoss;

    public Mog(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.f_19793_ = 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.DEPTHROCK_PEBBLE.get()}), false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22278_, 0.9);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UGSoundEvents.MOG_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.MOG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.MOG_DEATH.get();
    }

    public boolean m_6040_() {
        return true;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)UGEntityTypes.MOG.get()).m_20615_((Level)level);
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.DEPTHROCK_PEBBLE.get()}).test(stack);
    }

    public void m_8119_() {
        super.m_8119_();
        this.timeWithoutMoss = !this.hasMoss() ? ++this.timeWithoutMoss : 0;
        if (this.timeWithoutMoss == 6000) {
            this.setMoss(true);
        }
    }

    public boolean hasMoss() {
        return (Boolean)this.f_19804_.m_135370_(HAS_MOSS);
    }

    public void setMoss(boolean hasMoss) {
        this.f_19804_.m_135381_(HAS_MOSS, (Object)hasMoss);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.2f;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("HasMoss", this.hasMoss());
        this.timeWithoutMoss = nbt.m_128451_("TimeWithoutMoss");
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setMoss(nbt.m_128471_("HasMoss"));
        nbt.m_128405_("TimeWithoutMoss", this.timeWithoutMoss);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_MOSS, (Object)true);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        this.setMoss(true);
        return super.m_6518_(level, difficulty, spawnType, data, nbt);
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.hasMoss() && this.m_6084_() && !this.m_6162_();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack stack, Level level, BlockPos pos, int fortune) {
        level.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!level.f_46443_) {
            this.setMoss(false);
            int mossAmount = 1 + this.f_19796_.m_188503_(2);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < mossAmount; ++i) {
                items.add(new ItemStack((ItemLike)UGItems.MOGMOSS.get()));
            }
            return items;
        }
        return Collections.emptyList();
    }
}

