/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.client.render.ui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.client.render.ui.Rectangle;
import tv.soaryn.xycraft.core.client.render.ui.TiledIcon;

public class NineSlicedResource {
    private final Rectangle[] slicesNew = new Rectangle[9];
    private final ResourceLocation _resource;
    public final int ImageResolution;
    public final int MinWidth;
    public final int MinHeight;

    public NineSlicedResource(ResourceLocation loc) {
        this(loc, 0x40FF00FF);
    }

    public NineSlicedResource(ResourceLocation loc, int colorMask) {
        int y;
        int x;
        NativeImage image;
        this._resource = loc;
        Arrays.setAll(this.slicesNew, Rectangle::supplier);
        int res = 16;
        int[] notes = new int[6];
        Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(this._resource);
        if (resource.isEmpty()) {
            this.ImageResolution = 0;
            this.MinWidth = 0;
            this.MinHeight = 0;
            return;
        }
        try {
            image = NativeImage.m_85058_((InputStream)((Resource)resource.get()).m_215507_());
        }
        catch (IOException e) {
            this.ImageResolution = 0;
            this.MinWidth = 0;
            this.MinHeight = 0;
            return;
        }
        res = image.m_84982_();
        for (x = 0; x < res; ++x) {
            notes[0] = x;
            if (image.m_84985_(x, 0) == 0x40FF00FF) break;
        }
        for (x = notes[0] + 1; x < res; ++x) {
            notes[1] = x;
            if (image.m_84985_(x, 0) == 0x40FF00FF) break;
        }
        for (y = 0; y < res; ++y) {
            notes[3] = y;
            if (image.m_84985_(0, y) == 0x40FF00FF) break;
        }
        for (y = notes[3] + 1; y < res; ++y) {
            notes[4] = y;
            if (image.m_84985_(0, y) == 0x40FF00FF) break;
        }
        for (x = 0; x < res; ++x) {
            int current = image.m_84985_(x, notes[3]);
            if (current != 0x40FF00FF) {
                notes[2] = x - 1;
                break;
            }
            if (res - 1 != x) continue;
            notes[2] = x;
            break;
        }
        for (y = 0; y < res; ++y) {
            if (image.m_84985_(notes[0], y) != 0x40FF00FF) {
                notes[5] = y - 1;
                break;
            }
            if (res - 1 != y) continue;
            notes[5] = y;
            break;
        }
        int x0 = 0;
        int x1 = notes[0];
        int x2 = notes[1];
        int x3 = notes[2];
        int y0 = 0;
        int y1 = notes[3];
        int y2 = notes[4];
        int y3 = notes[5];
        this.slicesNew[0] = new Rectangle(x0 + 0, y0 + 0, x1 + 0, y1 + 0);
        this.slicesNew[1] = new Rectangle(x1 + 1, y0 + 0, x2 - x1 - 1, y1);
        this.slicesNew[2] = new Rectangle(x2 + 1, y0 + 0, x3 - x2, y1 + 0);
        this.slicesNew[3] = new Rectangle(x0 + 0, y1 + 1, x1 + 0, y2 - y1 - 1);
        this.slicesNew[4] = new Rectangle(x1 + 1, y1 + 1, x2 - x1 - 1, y2 - y1 - 1);
        this.slicesNew[5] = new Rectangle(x2 + 1, y1 + 1, x3 - x2, y2 - y1 - 1);
        this.slicesNew[6] = new Rectangle(x0 + 0, y2 + 1, x1 + 0, y3 - y2);
        this.slicesNew[7] = new Rectangle(x1 + 1, y2 + 1, x2 - x1 - 1, y3 - y2);
        this.slicesNew[8] = new Rectangle(x2 + 1, y2 + 1, x3 - x2, y3 - y2);
        this.ImageResolution = res;
        this.MinWidth = notes[2] - 2;
        this.MinHeight = notes[5] - 2;
    }

    public float getMinWidth() {
        return this.getMinWidth(0.0f);
    }

    public float getMinWidth(float current) {
        return Math.max(current, (float)this.MinWidth);
    }

    public float getMinHeight() {
        return this.getMinHeight(0.0f);
    }

    public float getMinHeight(float current) {
        return Math.max(current, (float)this.MinHeight);
    }

    public ResourceLocation get_resource() {
        return this._resource;
    }

    public void render(@NotNull PoseStack matrixStack, float x, float y, float width, float height, float scale) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this._resource);
        int i = 0;
        width = Math.max(width - (float)this.MinWidth, 1.0f);
        height = Math.max(height - (float)this.MinHeight, 1.0f);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        matrixStack.m_85841_(scale, scale, scale);
        TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), this.slicesNew[i].x() + 0.0f, this.slicesNew[i].x() + this.slicesNew[i].width(), this.slicesNew[i].y() - 0.0f, this.slicesNew[i].y() - 0.0f + this.slicesNew[i].height(), 0.0f, this.slicesNew[i].x() / (float)this.ImageResolution, (this.slicesNew[i].x() + this.slicesNew[i].width()) / (float)this.ImageResolution, this.slicesNew[i].y() / (float)this.ImageResolution, (this.slicesNew[i].y() + this.slicesNew[i].height()) / (float)this.ImageResolution);
        TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), this.slicesNew[++i].x() - 1.0f, this.slicesNew[i].x() - 2.0f + this.slicesNew[i].width() + width, this.slicesNew[i].y() - 0.0f, this.slicesNew[i].y() - 0.0f + this.slicesNew[i].height(), 0.0f, this.slicesNew[i].x() / (float)this.ImageResolution, (this.slicesNew[i].x() + this.slicesNew[i].width()) / (float)this.ImageResolution, this.slicesNew[i].y() / (float)this.ImageResolution, (this.slicesNew[i].y() + this.slicesNew[i].height()) / (float)this.ImageResolution);
        TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), this.slicesNew[++i].x() - 3.0f + width, this.slicesNew[i].x() - 3.0f + this.slicesNew[i].width() + width, this.slicesNew[i].y() - 0.0f, this.slicesNew[i].y() - 0.0f + this.slicesNew[i].height(), 0.0f, this.slicesNew[i].x() / (float)this.ImageResolution, (this.slicesNew[i].x() + this.slicesNew[i].width()) / (float)this.ImageResolution, this.slicesNew[i].y() / (float)this.ImageResolution, (this.slicesNew[i].y() + this.slicesNew[i].height()) / (float)this.ImageResolution);
        TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), this.slicesNew[++i].x() + 0.0f, this.slicesNew[i].x() + this.slicesNew[i].width(), this.slicesNew[i].y() - 1.0f, this.slicesNew[i].y() - 2.0f + this.slicesNew[i].height() + height, 0.0f, this.slicesNew[i].x() / (float)this.ImageResolution, (this.slicesNew[i].x() + this.slicesNew[i].width()) / (float)this.ImageResolution, this.slicesNew[i].y() / (float)this.ImageResolution, (this.slicesNew[i].y() + this.slicesNew[i].height()) / (float)this.ImageResolution);
        TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), this.slicesNew[++i].x() - 1.0f, this.slicesNew[i].x() - 2.0f + this.slicesNew[i].width() + width, this.slicesNew[i].y() - 1.0f, this.slicesNew[i].y() - 2.0f + this.slicesNew[i].height() + height, 0.0f, this.slicesNew[i].x() / (float)this.ImageResolution, (this.slicesNew[i].x() + this.slicesNew[i].width()) / (float)this.ImageResolution, this.slicesNew[i].y() / (float)this.ImageResolution, (this.slicesNew[i].y() + this.slicesNew[i].height()) / (float)this.ImageResolution);
        TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), this.slicesNew[++i].x() - 3.0f + width, this.slicesNew[i].x() - 3.0f + this.slicesNew[i].width() + width, this.slicesNew[i].y() - 1.0f, this.slicesNew[i].y() - 2.0f + this.slicesNew[i].height() + height, 0.0f, this.slicesNew[i].x() / (float)this.ImageResolution, (this.slicesNew[i].x() + this.slicesNew[i].width()) / (float)this.ImageResolution, this.slicesNew[i].y() / (float)this.ImageResolution, (this.slicesNew[i].y() + this.slicesNew[i].height()) / (float)this.ImageResolution);
        TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), this.slicesNew[++i].x() + 0.0f, this.slicesNew[i].x() + this.slicesNew[i].width(), this.slicesNew[i].y() - 3.0f + height, this.slicesNew[i].y() - 3.0f + this.slicesNew[i].height() + height, 0.0f, this.slicesNew[i].x() / (float)this.ImageResolution, (this.slicesNew[i].x() + this.slicesNew[i].width()) / (float)this.ImageResolution, this.slicesNew[i].y() / (float)this.ImageResolution, (this.slicesNew[i].y() + this.slicesNew[i].height()) / (float)this.ImageResolution);
        TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), this.slicesNew[++i].x() - 1.0f, this.slicesNew[i].x() - 2.0f + this.slicesNew[i].width() + width, this.slicesNew[i].y() - 3.0f + height, this.slicesNew[i].y() - 3.0f + this.slicesNew[i].height() + height, 0.0f, this.slicesNew[i].x() / (float)this.ImageResolution, (this.slicesNew[i].x() + this.slicesNew[i].width()) / (float)this.ImageResolution, this.slicesNew[i].y() / (float)this.ImageResolution, (this.slicesNew[i].y() + this.slicesNew[i].height()) / (float)this.ImageResolution);
        TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), this.slicesNew[++i].x() - 3.0f + width, this.slicesNew[i].x() - 3.0f + this.slicesNew[i].width() + width, this.slicesNew[i].y() - 3.0f + height, this.slicesNew[i].y() - 3.0f + this.slicesNew[i].height() + height, 0.0f, this.slicesNew[i].x() / (float)this.ImageResolution, (this.slicesNew[i].x() + this.slicesNew[i].width()) / (float)this.ImageResolution, this.slicesNew[i].y() / (float)this.ImageResolution, (this.slicesNew[i].y() + this.slicesNew[i].height()) / (float)this.ImageResolution);
        matrixStack.m_85849_();
    }
}

