/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.flag;

import earth.terrarium.ad_astra.client.screen.FlagUrlScreen;
import earth.terrarium.ad_astra.common.block.flag.EightDirectionProperty;
import earth.terrarium.ad_astra.common.block.flag.FlagBlockEntity;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class FlagBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EightDirectionProperty FACING = new EightDirectionProperty();
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public FlagBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_ && (AdAstraConfig.allowFlagImages || player.m_36337_())) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                return this.action(level, pos.m_7494_(), player);
            }
            return this.action(level, pos, player);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private InteractionResult action(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FlagBlockEntity) {
            FlagBlockEntity flagBlock = (FlagBlockEntity)blockEntity;
            if (flagBlock.getOwner() != null && player.m_20148_().equals(flagBlock.getOwner().getId())) {
                FlagUrlScreen.open(pos);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"message.ad_astra.flag.not_owner"), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape pole = Shapes.m_83048_((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)1.5, (double)0.5625);
        if (((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            return Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.5, (double)0.625), (VoxelShape)pole);
        }
        return pole;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.m_6861_(state, level, pos, block, fromPos, notify);
        if (!level.f_46443_) {
            if (((DoubleBlockHalf)level.m_8055_(pos).m_61143_(HALF)).equals((Object)DoubleBlockHalf.LOWER) && level.m_8055_(pos.m_7494_()).m_60795_()) {
                level.m_46961_(pos, false);
            } else if (((DoubleBlockHalf)level.m_8055_(pos).m_61143_(HALF)).equals((Object)DoubleBlockHalf.UPPER) && level.m_8055_(pos.m_7495_()).m_60795_()) {
                level.m_46961_(pos, false);
            }
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(level, pos, state, placer, itemStack);
        boolean waterAbove = level.m_6425_(pos.m_7494_()).m_192917_((Fluid)Fluids.f_76193_);
        level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterAbove)), 3);
        BlockEntity blockEntity = level.m_7702_(pos.m_7494_());
        if (placer instanceof Player) {
            Player player = (Player)placer;
            if (blockEntity instanceof FlagBlockEntity) {
                FlagBlockEntity flagEntity = (FlagBlockEntity)blockEntity;
                flagEntity.setOwner(player.m_36316_());
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FlagBlockEntity(pos, state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)((Object)((EightDirectionProperty.Direction)((Object)state.m_61143_((Property)FACING))).rotate(rotation)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)((Object)((EightDirectionProperty.Direction)((Object)state.m_61143_((Property)FACING))).mirror(mirror)));
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.LOWER) ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, HALF});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return Block.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_()) && level.m_8055_(pos.m_7494_()).m_60795_();
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        EightDirectionProperty.Direction value = EightDirectionProperty.Direction.VALUES[Mth.m_14107_((double)((double)(ctx.m_7074_() * 8.0f / 360.0f) + 0.5)) & 7];
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)((Object)value))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_().equals(Fluids.f_76193_)));
    }
}

