/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.combiner;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.smashingmods.alchemistry.client.container.RecipeSelectorScreen;
import com.smashingmods.alchemistry.client.container.button.IOConfigurationButton;
import com.smashingmods.alchemistry.common.block.combiner.CombinerBlockEntity;
import com.smashingmods.alchemistry.common.block.combiner.CombinerMenu;
import com.smashingmods.alchemistry.common.recipe.combiner.CombinerRecipe;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.blockentity.container.AbstractProcessingMenu;
import com.smashingmods.alchemylib.api.blockentity.container.AbstractProcessingScreen;
import com.smashingmods.alchemylib.api.blockentity.container.Direction2D;
import com.smashingmods.alchemylib.api.blockentity.container.FakeItemRenderer;
import com.smashingmods.alchemylib.api.blockentity.container.data.AbstractDisplayData;
import com.smashingmods.alchemylib.api.blockentity.container.data.EnergyDisplayData;
import com.smashingmods.alchemylib.api.blockentity.container.data.ProgressDisplayData;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import com.smashingmods.alchemylib.client.button.LockButton;
import com.smashingmods.alchemylib.client.button.PauseButton;
import com.smashingmods.alchemylib.client.button.RecipeSelectorButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class CombinerScreen
extends AbstractProcessingScreen<CombinerMenu> {
    protected final List<AbstractDisplayData> displayData = new ArrayList<AbstractDisplayData>();
    private final CombinerBlockEntity blockEntity;
    private final LockButton lockButton = new LockButton((AbstractProcessingScreen)this);
    private final PauseButton pauseButton = new PauseButton((AbstractProcessingScreen)this);
    private final IOConfigurationButton sideConfigButton = new IOConfigurationButton(this);
    private final RecipeSelectorScreen<CombinerScreen, CombinerBlockEntity, CombinerRecipe> recipeSelectorScreen;
    private final RecipeSelectorButton recipeSelector;

    public CombinerScreen(CombinerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractProcessingMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 184;
        this.f_97727_ = 193;
        this.displayData.add((AbstractDisplayData)new ProgressDisplayData(pMenu.getBlockEntity(), 87, 35, 60, 9, Direction2D.RIGHT));
        this.displayData.add((AbstractDisplayData)new EnergyDisplayData(pMenu.getBlockEntity(), 12, 12, 16, 54));
        this.blockEntity = (CombinerBlockEntity)pMenu.getBlockEntity();
        this.recipeSelectorScreen = new RecipeSelectorScreen<CombinerScreen, CombinerBlockEntity, CombinerRecipe>(this, (CombinerBlockEntity)((CombinerMenu)this.m_6262_()).getBlockEntity(), RecipeRegistry.getCombinerRecipes(pMenu.getLevel()));
        this.recipeSelector = new RecipeSelectorButton((AbstractProcessingScreen)this, this.recipeSelectorScreen);
    }

    protected void m_7856_() {
        this.recipeSelectorScreen.setTopPos((this.f_96544_ - this.f_97727_) / 2);
        this.widgets.add(this.lockButton);
        this.widgets.add(this.pauseButton);
        this.widgets.add(this.recipeSelector);
        this.widgets.add(this.sideConfigButton);
        super.m_7856_();
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderDisplayData(this.displayData, pPoseStack, this.f_97735_, this.f_97736_);
        this.renderCurrentRecipe(pPoseStack, pMouseX, pMouseY);
        this.m_7025_(pPoseStack, pMouseX, pMouseY);
        this.renderDisplayTooltip(this.displayData, pPoseStack, this.f_97735_, this.f_97736_, pMouseX, pMouseY);
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("alchemistry", "textures/gui/combiner_gui.png"));
        this.m_93228_(pPoseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        MutableComponent title = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("alchemistry.container.combiner"));
        CombinerScreen.m_93243_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)title, (int)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)title) / 2), (int)-10, (int)-1);
    }

    private void renderCurrentRecipe(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        CombinerRecipe currentRecipe = (CombinerRecipe)((CombinerMenu)this.f_97732_).getBlockEntity().getRecipe();
        ProcessingSlotHandler handler = this.blockEntity.getInputHandler();
        if (currentRecipe != null) {
            ItemStack currentOutput = currentRecipe.getOutput();
            this.f_96542_.m_115203_(currentOutput, this.f_97735_ + 152, this.f_97736_ + 15);
            if (pMouseX >= this.f_97735_ + 149 && pMouseX < this.f_97735_ + 173 && pMouseY >= this.f_97736_ + 11 && pMouseY < this.f_97736_ + 35) {
                this.renderItemTooltip(pPoseStack, currentOutput, MutableComponent.m_237204_((ComponentContents)new TranslatableContents("alchemistry.container.combiner.current_recipe")), pMouseX, pMouseY);
            }
            int xOrigin = this.f_97735_ + 48;
            int yOrigin = this.f_97736_ + 22;
            for (int row = 0; row < 2; ++row) {
                for (int column = 0; column < 2; ++column) {
                    int index = column + row * 2;
                    int x = xOrigin + column * 18;
                    int y = yOrigin + row * 18;
                    if (index >= currentRecipe.getInput().size()) continue;
                    ItemStack itemStack = ((IngredientStack)currentRecipe.getInput().get(index)).getIngredient().m_43908_()[(int)(Math.random() * (double)((IngredientStack)currentRecipe.getInput().get(index)).getIngredient().m_43908_().length)];
                    if (!handler.getStackInSlot(index).m_41619_()) continue;
                    FakeItemRenderer.renderFakeItem((ItemStack)itemStack, (int)x, (int)y, (float)0.35f);
                    this.f_96542_.m_115169_(this.f_96547_, itemStack, x, y);
                    if (pMouseX < x - 2 || pMouseX >= x + 16 || pMouseY < y - 1 || pMouseY >= y + 17) continue;
                    this.renderItemTooltip(pPoseStack, itemStack, MutableComponent.m_237204_((ComponentContents)new TranslatableContents("alchemistry.container.required_input")), pMouseX, pMouseY);
                }
            }
        }
    }
}

