/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.network.jei;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.client.jei.RecipeTypes;
import com.smashingmods.alchemistry.common.block.combiner.CombinerBlockEntity;
import com.smashingmods.alchemistry.common.block.combiner.CombinerMenu;
import com.smashingmods.alchemistry.common.network.jei.TransferUtils;
import com.smashingmods.alchemistry.common.recipe.combiner.CombinerRecipe;
import com.smashingmods.alchemistry.registry.MenuRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.alchemylib.api.network.AlchemyPacket;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class CombinerTransferPacket
implements AlchemyPacket {
    private final BlockPos blockPos;
    private final ItemStack output;
    private final boolean maxTransfer;

    public CombinerTransferPacket(BlockPos pBlockPos, ItemStack pOutput, boolean pMaxTransfer) {
        this.blockPos = pBlockPos;
        this.output = pOutput;
        this.maxTransfer = pMaxTransfer;
    }

    public CombinerTransferPacket(FriendlyByteBuf pBuffer) {
        this.blockPos = pBuffer.m_130135_();
        this.output = pBuffer.m_130267_();
        this.maxTransfer = pBuffer.readBoolean();
    }

    public void encode(FriendlyByteBuf pBuffer) {
        pBuffer.m_130064_(this.blockPos);
        pBuffer.m_130055_(this.output);
        pBuffer.writeBoolean(this.maxTransfer);
    }

    public void handle(NetworkEvent.Context pContext) {
        ServerPlayer player = pContext.getSender();
        Objects.requireNonNull(player);
        CombinerBlockEntity blockEntity = (CombinerBlockEntity)player.m_9236_().m_7702_(this.blockPos);
        Objects.requireNonNull(blockEntity);
        ProcessingSlotHandler inputHandler = blockEntity.getInputHandler();
        ProcessingSlotHandler outputHandler = blockEntity.getOutputHandler();
        Inventory inventory = player.m_150109_();
        RecipeRegistry.getCombinerRecipe(recipe -> ItemStack.m_150942_((ItemStack)recipe.getOutput(), (ItemStack)this.output), (Level)player.m_9236_()).ifPresent(recipe -> {
            boolean canTransfer;
            CombinerRecipe recipeCopy = recipe.copy();
            inputHandler.emptyToInventory(inventory);
            outputHandler.emptyToInventory(inventory);
            List<ItemStack> inventoryInput = TransferUtils.matchIngredientListToItemStack((NonNullList<ItemStack>)inventory.f_35974_, (List<IngredientStack>)recipeCopy.getInput());
            ArrayList<ItemStack> recipeInput = new ArrayList<ItemStack>();
            IntStream.range(0, inventoryInput.size()).forEach(i -> recipeInput.add(new ItemStack((ItemLike)((ItemStack)inventoryInput.get(i)).m_41720_(), ((IngredientStack)recipeCopy.getInput().get(i)).getCount())));
            boolean creative = player.f_8941_.m_9295_();
            boolean bl = canTransfer = (!inventoryInput.isEmpty() || creative) && inputHandler.isEmpty() && outputHandler.isEmpty();
            if (canTransfer) {
                if (creative) {
                    ArrayList<ItemStack> creativeInput = new ArrayList<ItemStack>();
                    for (int i2 = 0; i2 < recipeCopy.getInput().size(); ++i2) {
                        ItemStack item = new ItemStack((ItemLike)((IngredientStack)recipeCopy.getInput().get(i2)).getIngredient().m_43908_()[0].m_41720_(), ((IngredientStack)recipeCopy.getInput().get(i2)).getCount());
                        creativeInput.add(i2, item);
                    }
                    int maxOperations = TransferUtils.getMaxOperations(creativeInput, this.maxTransfer);
                    for (int i3 = 0; i3 < recipeCopy.getInput().size(); ++i3) {
                        inputHandler.setOrIncrement(i3, new ItemStack((ItemLike)((ItemStack)creativeInput.get(i3)).m_41720_(), ((IngredientStack)recipeCopy.getInput().get(i3)).getCount() * maxOperations));
                    }
                } else {
                    ArrayList<ItemStack> inventoryStacks = new ArrayList<ItemStack>();
                    inventoryInput.stream().map(arg_0 -> ((Inventory)inventory).m_36030_(arg_0)).forEach(slot -> {
                        if (slot != -1) {
                            inventoryStacks.add(inventory.m_8020_(slot.intValue()));
                        }
                    });
                    int maxOperations = TransferUtils.getMaxOperations(recipeInput, inventoryStacks, this.maxTransfer, false);
                    recipeInput.forEach(itemStack -> {
                        int slot = player.m_150109_().m_36030_(itemStack);
                        player.m_150109_().m_7407_(slot, itemStack.m_41613_() * maxOperations);
                    });
                    for (int i4 = 0; i4 < recipeCopy.getInput().size(); ++i4) {
                        inputHandler.setOrIncrement(i4, new ItemStack((ItemLike)((ItemStack)recipeInput.get(i4)).m_41720_(), ((IngredientStack)recipeCopy.getInput().get(i4)).getCount() * maxOperations));
                    }
                }
                blockEntity.setProgress(0);
                blockEntity.setRecipe(recipe);
                blockEntity.setCanProcess(true);
            }
        });
    }

    public static class TransferHandler
    implements IRecipeTransferHandler<CombinerMenu, CombinerRecipe> {
        public Class<CombinerMenu> getContainerClass() {
            return CombinerMenu.class;
        }

        public Optional<MenuType<CombinerMenu>> getMenuType() {
            return Optional.of((MenuType)MenuRegistry.COMBINER_MENU.get());
        }

        public RecipeType<CombinerRecipe> getRecipeType() {
            return RecipeTypes.COMBINER;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(CombinerMenu pContainer, CombinerRecipe pRecipe, IRecipeSlotsView pRecipeSlots, Player pPlayer, boolean pMaxTransfer, boolean pDoTransfer) {
            if (pDoTransfer) {
                pContainer.getBlockEntity().setRecipe((AbstractProcessingRecipe)pRecipe);
                Alchemistry.PACKET_HANDLER.sendToServer(new CombinerTransferPacket(pContainer.getBlockEntity().m_58899_(), pRecipe.getOutput(), pMaxTransfer));
            }
            return null;
        }
    }
}

