/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.recipe.combiner;

import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class CombinerRecipe
extends AbstractProcessingRecipe {
    private final ItemStack output;
    private final Set<IngredientStack> input = new LinkedHashSet<IngredientStack>();

    public CombinerRecipe(ResourceLocation pId, String pGroup, Set<IngredientStack> pInputList, ItemStack pOutput) {
        super(pId, pGroup);
        this.output = pOutput;
        this.input.addAll(pInputList);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.COMBINER_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.COMBINER_TYPE.get();
    }

    public ItemStack assemble(Inventory pContainer) {
        return this.output;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public String toString() {
        return String.format("input=[%s],output=[%s]", this.input, this.output);
    }

    public int compareTo(@NotNull AbstractProcessingRecipe pRecipe) {
        return this.m_6423_().compareTo(pRecipe.m_6423_());
    }

    public CombinerRecipe copy() {
        return new CombinerRecipe(this.m_6423_(), this.m_6076_(), Set.copyOf(this.input), this.output.m_41777_());
    }

    public List<IngredientStack> getInput() {
        return new LinkedList<IngredientStack>(this.input);
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public boolean matchInputs(List<ItemStack> pStacks) {
        List<ItemStack> inputStacks = pStacks.stream().filter(itemStack -> !itemStack.m_41619_()).toList();
        return this.input.stream().allMatch(ingredientStack -> inputStacks.stream().anyMatch(itemStack -> itemStack.m_41613_() >= ingredientStack.getCount() && ingredientStack.matches(itemStack))) && this.input.size() == inputStacks.size();
    }
}

