/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.recipe.dissolver;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.smashingmods.alchemistry.common.recipe.dissolver.DissolverRecipe;
import com.smashingmods.alchemistry.common.recipe.dissolver.ProbabilityGroup;
import com.smashingmods.alchemistry.common.recipe.dissolver.ProbabilitySet;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;

public class DissolverRecipeSerializer<T extends DissolverRecipe>
implements RecipeSerializer<T> {
    private final IFactory<T> factory;

    public DissolverRecipeSerializer(IFactory<T> pFactory) {
        this.factory = pFactory;
    }

    public T fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
        String group = pSerializedRecipe.get("group").getAsString();
        IngredientStack input = IngredientStack.fromJson((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"input"));
        JsonObject outputJson = pSerializedRecipe.getAsJsonObject("output");
        int rolls = outputJson.get("rolls").getAsInt();
        boolean weighted = outputJson.get("weighted").getAsBoolean();
        ArrayList<ProbabilityGroup> groups = new ArrayList<ProbabilityGroup>();
        JsonArray groupArray = outputJson.getAsJsonArray("groups");
        for (JsonElement element : groupArray) {
            ArrayList<ItemStack> output = new ArrayList<ItemStack>();
            JsonObject jsonObject = element.getAsJsonObject();
            for (JsonElement stack : jsonObject.getAsJsonArray("results")) {
                try {
                    output.add(CraftingHelper.getItemStack((JsonObject)stack.getAsJsonObject(), (boolean)false, (boolean)false));
                }
                catch (JsonSyntaxException exception) {
                    exception.printStackTrace();
                }
            }
            double probability = jsonObject.get("probability").getAsFloat();
            groups.add(new ProbabilityGroup(output, probability));
        }
        return (T)((Object)((DissolverRecipe)((Object)this.factory.create(pRecipeId, group, input, new ProbabilitySet(groups, weighted, rolls)))));
    }

    public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        String group = pBuffer.m_130136_(Short.MAX_VALUE);
        IngredientStack input = IngredientStack.fromNetwork((FriendlyByteBuf)pBuffer);
        ProbabilitySet output = ProbabilitySet.fromNetwork(pBuffer);
        return (T)((Object)((DissolverRecipe)((Object)this.factory.create(pRecipeId, group, input, output))));
    }

    public void toNetwork(FriendlyByteBuf pBuffer, T pRecipe) {
        pBuffer.m_130070_(pRecipe.m_6076_());
        ((DissolverRecipe)((Object)pRecipe)).getInput().toNetwork(pBuffer);
        ((DissolverRecipe)((Object)pRecipe)).getOutput().toNetwork(pBuffer);
    }

    public static interface IFactory<T extends Recipe<Inventory>> {
        public T create(ResourceLocation var1, String var2, IngredientStack var3, ProbabilitySet var4);
    }
}

