/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen;

import com.smashingmods.alchemistry.registry.BlockRegistry;
import com.smashingmods.alchemylib.api.blockentity.power.PowerState;
import com.smashingmods.alchemylib.api.blockentity.power.PowerStateProperty;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class BlockStateGenerator
extends BlockStateProvider {
    public BlockStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "alchemistry", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModelFile.ExistingModelFile atomizerModel = new ModelFile.ExistingModelFile(this.modLoc("block/atomizer"), this.models().existingFileHelper);
        ModelFile.ExistingModelFile combinerModel = new ModelFile.ExistingModelFile(this.modLoc("block/combiner"), this.models().existingFileHelper);
        ModelFile.ExistingModelFile dissolverModel = new ModelFile.ExistingModelFile(this.modLoc("block/dissolver"), this.models().existingFileHelper);
        ModelFile.ExistingModelFile liquifierModel = new ModelFile.ExistingModelFile(this.modLoc("block/liquifier"), this.models().existingFileHelper);
        this.registerMachineModel(BlockRegistry.ATOMIZER, (ModelFile)atomizerModel);
        this.registerMachineModel(BlockRegistry.COMBINER, (ModelFile)combinerModel);
        this.registerMachineModel(BlockRegistry.DISSOLVER, (ModelFile)dissolverModel);
        this.registerMachineModel(BlockRegistry.LIQUIFIER, (ModelFile)liquifierModel);
        this.registerControllerModel(BlockRegistry.FISSION_CONTROLLER);
        this.registerControllerModel(BlockRegistry.FUSION_CONTROLLER);
        this.registerAxisBlock(BlockRegistry.FISSION_CORE);
        this.registerAxisBlock(BlockRegistry.FUSION_CORE);
        this.registerSimpleBlockWithRenderType(BlockRegistry.REACTOR_CASING, "solid");
        this.registerSimpleBlockWithRenderType(BlockRegistry.REACTOR_GLASS, "translucent");
        this.registerReactorIOModels();
    }

    private void registerSimpleBlock(RegistryObject<Block> pBlock) {
        this.simpleBlock((Block)pBlock.get());
        this.registerBlockItemModel(pBlock);
    }

    private void registerSimpleBlockWithRenderType(RegistryObject<Block> pBlock, String pRenderType) {
        ConfiguredModel[] model = ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(pBlock.getId().m_135815_(), this.mcLoc("block/cube_all"))).renderType(pRenderType)).texture("all", this.blockTexture((Block)pBlock.get()))).build();
        this.getVariantBuilder((Block)pBlock.get()).partialState().setModels(model);
        this.registerBlockItemModel(pBlock);
    }

    private void registerAxisBlock(RegistryObject<RotatedPillarBlock> pBlock) {
        this.axisBlock((RotatedPillarBlock)pBlock.get());
        this.registerBlockItemModel(pBlock);
    }

    private <T extends Block> void registerBlockItemModel(RegistryObject<T> pBlock) {
        this.itemModels().withExistingParent(pBlock.getId().m_135815_(), this.modLoc(String.format("block/%s", pBlock.getId().m_135815_())));
    }

    private void registerMachineModel(RegistryObject<Block> pBlock, ModelFile pModelFile) {
        this.getVariantBuilder((Block)pBlock.get()).forAllStates(blockState -> {
            Direction direction = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            return ConfiguredModel.builder().modelFile(pModelFile).rotationX(direction.m_122434_() == Direction.Axis.Y ? direction.m_122421_().m_122540_() * -19 : 0).rotationY(direction.m_122434_() == Direction.Axis.Y ? (direction.m_122416_() + 2) % 4 * 90 : 0).build();
        });
        this.registerBlockItemModel(pBlock);
    }

    private void registerControllerModel(RegistryObject<Block> pBlock) {
        Block controller = (Block)pBlock.get();
        this.getVariantBuilder(controller).forAllStates(blockState -> {
            Direction direction = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
            String path = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)controller)).m_135815_();
            String type = path.split("_")[0];
            String modelName = String.format("block/%s_%s", path, ((PowerState)blockState.m_61143_((Property)PowerStateProperty.POWER_STATE)).m_7912_());
            ResourceLocation face = this.modLoc(modelName);
            ResourceLocation back = this.modLoc(String.format("block/%s_chamber_controller_back", type));
            ResourceLocation hSide = this.modLoc(String.format("block/%s_chamber_controller_hside", type));
            ResourceLocation vSide = this.modLoc(String.format("block/%s_chamber_controller_vside", type));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("block/cube"))).renderType("solid")).texture("particle", hSide)).texture("down", vSide)).texture("up", vSide)).texture("north", face)).texture("south", back)).texture("east", hSide)).texture("west", hSide)).rotationX(direction.m_122434_() == Direction.Axis.Y ? direction.m_122421_().m_122540_() * -90 : 0).rotationY(direction.m_122434_() != Direction.Axis.Y ? (direction.m_122416_() + 2) % 4 * 90 : 0).build();
        });
        this.itemModels().withExistingParent(pBlock.getId().m_135815_(), this.modLoc(String.format("block/%s_standby", pBlock.getId().m_135815_())));
    }

    private void registerReactorIOModels() {
        ResourceLocation side = this.modLoc("block/reactor_casing");
        ResourceLocation input = this.modLoc("block/reactor_input");
        ResourceLocation output = this.modLoc("block/reactor_output");
        ResourceLocation energy = this.modLoc("block/reactor_energy");
        this.registerFaceBlock(BlockRegistry.REACTOR_INPUT, input, side);
        this.registerFaceBlock(BlockRegistry.REACTOR_OUTPUT, output, side);
        this.registerPoweredFaceBlock(BlockRegistry.REACTOR_ENERGY, energy, side);
    }

    private void registerFaceBlock(RegistryObject<Block> pBlock, ResourceLocation pFace, ResourceLocation pSide) {
        String path = pBlock.getId().m_135815_();
        this.getVariantBuilder((Block)pBlock.get()).forAllStates(blockState -> {
            Direction direction = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            ModelBuilder modelFile = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(path, this.mcLoc("block/cube"))).renderType("solid")).texture("particle", pSide)).texture("down", pSide)).texture("up", pSide)).texture("north", pFace)).texture("south", pSide)).texture("east", pSide)).texture("west", pSide);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFile).rotationX(direction.m_122434_() == Direction.Axis.Y ? direction.m_122421_().m_122540_() * -90 : 0).rotationY(direction.m_122434_() != Direction.Axis.Y ? (direction.m_122416_() + 2) % 4 * 90 : 0).build();
        });
        this.itemModels().withExistingParent(path, this.modLoc(String.format("block/%s", path)));
    }

    private void registerPoweredFaceBlock(RegistryObject<Block> pBlock, ResourceLocation pFace, ResourceLocation pSide) {
        String path = pBlock.getId().m_135815_();
        Function<PowerState, BlockModelBuilder> modelFunction = state -> {
            ResourceLocation location = null;
            switch (state) {
                case DISABLED: 
                case OFF: {
                    location = this.modLoc(String.format("%s_off", pFace.m_135815_()));
                    break;
                }
                case STANDBY: 
                case ON: {
                    location = this.modLoc(String.format("%s_on", pFace.m_135815_()));
                }
            }
            return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(String.format("%s_%s", path, state.m_7912_()), this.mcLoc("block/cube"))).renderType("solid")).texture("particle", pSide)).texture("down", pSide)).texture("up", pSide)).texture("north", location)).texture("south", pSide)).texture("east", pSide)).texture("west", pSide);
        };
        this.getVariantBuilder((Block)pBlock.get()).forAllStates(blockState -> {
            Direction direction = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunction.apply((PowerState)blockState.m_61143_((Property)PowerStateProperty.POWER_STATE))).rotationX(direction.m_122434_() == Direction.Axis.Y ? direction.m_122421_().m_122540_() * -90 : 0).rotationY(direction.m_122434_() != Direction.Axis.Y ? (direction.m_122416_() + 2) % 4 * 90 : 0).build();
        });
        this.itemModels().withExistingParent(path, this.modLoc(String.format("block/%s_off", path)));
    }
}

