/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.entity;

import com.thevortex.allthemodium.registry.ModRegistry;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class PiglichEntity
extends Piglin
implements IAnimatable {
    private final SimpleContainer inventory = new SimpleContainer(8);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private boolean isSummoning = false;

    public PiglichEntity(EntityType<? extends Piglin> type, Level world) {
        super(type, world);
        this.m_34670_(true);
        this.m_8099_();
    }

    public boolean m_6779_(LivingEntity entity) {
        return !(entity instanceof Player) || !((Player)entity).m_7500_();
    }

    protected void populateDefaultEquipementSlots(DifficultyInstance diff) {
        if (this.m_34667_()) {
            this.maybeWearArmor(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModRegistry.ALLTHEMODIUM_HELMET.get()));
            this.maybeWearArmor(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModRegistry.ALLTHEMODIUM_CHESTPLATE.get()));
            this.maybeWearArmor(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModRegistry.ALLTHEMODIUM_LEGGINGS.get()));
            this.maybeWearArmor(EquipmentSlot.FEET, new ItemStack((ItemLike)ModRegistry.ALLTHEMODIUM_BOOTS.get()));
        }
    }

    private void maybeWearArmor(EquipmentSlot slot, ItemStack stack) {
        if (this.f_19853_.f_46441_.m_188501_() < 0.5f) {
            this.m_8061_(slot, stack);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.inventory.m_7797_(tag.m_128437_("Inventory", 10));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 3.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(1, (Goal)new PigLichAttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    private ItemStack createSpawnWeapon() {
        return (double)this.f_19796_.m_188501_() < 0.4 ? new ItemStack((ItemLike)ModRegistry.ALLTHEMODIUM_SWORD.get()) : new ItemStack((ItemLike)Items.f_42393_);
    }

    public void m_34670_(boolean p_34671_) {
        super.m_34670_(true);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor sla, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        if (mobSpawnType != MobSpawnType.STRUCTURE) {
            this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon());
        }
        this.populateDefaultEquipementSlots(difficultyInstance);
        return super.m_6518_(sla, difficultyInstance, mobSpawnType, spawnGroupData, tag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.21f).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22284_, 24.0).m_22268_(Attributes.f_22285_, 24.0).m_22268_(Attributes.f_22276_, 9999.0);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walk.piglich.nik", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.isSummoning) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("summon.piglich.nik", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle.piglich.nik", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (!super.m_6469_(source, damage)) {
            return false;
        }
        if (!(this.f_19853_ instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverlevel = (ServerLevel)this.f_19853_;
        LivingEntity livingentity = this.m_5448_();
        if (livingentity == null && source.m_7639_() instanceof LivingEntity) {
            livingentity = (LivingEntity)source.m_7639_();
        }
        if (!(livingentity instanceof Player)) {
            return false;
        }
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        return this.spawnSupport(this, i, j, k);
    }

    protected boolean spawnSupport(PiglichEntity piglich, int i, int j, int k) {
        ServerLevel serverlevel = (ServerLevel)piglich.f_19853_;
        LivingEntity livingentity = piglich.m_5448_();
        int mobType = Mth.m_216271_((RandomSource)piglich.f_19796_, (int)1, (int)6);
        Monster spawnmob = (Monster)EntityType.f_20512_.m_20615_(piglich.f_19853_);
        switch (mobType) {
            case 1: {
                spawnmob = (Monster)EntityType.f_20512_.m_20615_(piglich.f_19853_);
            }
            case 2: {
                spawnmob = (Monster)EntityType.f_20551_.m_20615_(piglich.f_19853_);
            }
            case 3: {
                spawnmob = (Monster)EntityType.f_20566_.m_20615_(piglich.f_19853_);
            }
            case 4: {
                spawnmob = (Monster)EntityType.f_20568_.m_20615_(piglich.f_19853_);
            }
            case 5: {
                spawnmob = (Monster)EntityType.f_20493_.m_20615_(piglich.f_19853_);
            }
            case 6: {
                spawnmob = (Monster)EntityType.f_20495_.m_20615_(piglich.f_19853_);
            }
        }
        for (int l = 0; l < 5; ++l) {
            int i1 = i + Mth.m_216271_((RandomSource)piglich.f_19796_, (int)7, (int)40) * Mth.m_216271_((RandomSource)piglich.f_19796_, (int)-1, (int)1);
            int j1 = j + Mth.m_216271_((RandomSource)piglich.f_19796_, (int)7, (int)40) * Mth.m_216271_((RandomSource)piglich.f_19796_, (int)-1, (int)1);
            int k1 = k + Mth.m_216271_((RandomSource)piglich.f_19796_, (int)7, (int)40) * Mth.m_216271_((RandomSource)piglich.f_19796_, (int)-1, (int)1);
            BlockPos blockpos = new BlockPos(i1, j1, k1);
            EntityType entitytype = spawnmob.m_6095_();
            SpawnPlacements.Type spawnplacements$type = SpawnPlacements.m_21752_((EntityType)entitytype);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)spawnplacements$type, (LevelReader)piglich.f_19853_, (BlockPos)blockpos, (EntityType)entitytype) || !SpawnPlacements.m_217074_((EntityType)entitytype, (ServerLevelAccessor)serverlevel, (MobSpawnType)MobSpawnType.REINFORCEMENT, (BlockPos)blockpos, (RandomSource)piglich.f_19853_.f_46441_)) continue;
            spawnmob.m_6034_((double)i1, (double)j1, (double)k1);
            if (piglich.f_19853_.m_45914_((double)i1, (double)j1, (double)k1, 7.0) || !piglich.f_19853_.m_45784_((Entity)spawnmob) || !piglich.f_19853_.m_45786_((Entity)spawnmob) || piglich.f_19853_.m_46855_(spawnmob.m_20191_())) continue;
            if (livingentity != null) {
                spawnmob.m_6710_(livingentity);
            }
            spawnmob.m_6518_((ServerLevelAccessor)serverlevel, piglich.f_19853_.m_6436_(spawnmob.m_20183_()), MobSpawnType.REINFORCEMENT, (SpawnGroupData)null, (CompoundTag)null);
            serverlevel.m_47205_((Entity)spawnmob);
        }
        this.isSummoning = true;
        return true;
    }

    static class PigLichAttackGoal
    extends Goal {
        private final PiglichEntity piglich;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public PigLichAttackGoal(PiglichEntity p_32247_) {
            this.piglich = p_32247_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.piglich.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.piglich.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.lastSeen = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity livingentity = this.piglich.m_5448_();
            if (livingentity != null) {
                boolean flag = this.piglich.m_21574_().m_148306_((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.piglich.m_20280_((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.piglich.m_7327_((Entity)livingentity);
                    }
                    this.piglich.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.m_20185_() - this.piglich.m_20185_();
                    double d2 = livingentity.m_20227_(0.5) - this.piglich.m_20227_(0.5);
                    double d3 = livingentity.m_20189_() - this.piglich.m_20189_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            if (!this.piglich.m_20067_()) {
                                this.piglich.f_19853_.m_5898_((Player)null, 1018, this.piglich.m_20183_(), 0);
                            }
                        }
                    }
                    this.piglich.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.piglich.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
        }

        private double getFollowDistance() {
            return this.piglich.m_21133_(Attributes.f_22277_);
        }
    }
}

