/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import com.google.common.base.Preconditions;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;

public class CubeBuilder {
    private final List<BakedQuad> output;
    private final EnumMap<Direction, TextureAtlasSprite> textures = new EnumMap(Direction.class);
    private EnumSet<Direction> drawFaces = EnumSet.allOf(Direction.class);
    private final EnumMap<Direction, Vector4f> customUv = new EnumMap(Direction.class);
    private byte[] uvRotations = new byte[Direction.values().length];
    private int color = -1;
    private boolean useStandardUV = false;
    private boolean emissiveMaterial;

    public CubeBuilder(List<BakedQuad> output) {
        this.output = output;
    }

    public CubeBuilder() {
        this(new ArrayList<BakedQuad>(6));
    }

    public void addCube(float x1, float y1, float z1, float x2, float y2, float z2) {
        x1 /= 16.0f;
        y1 /= 16.0f;
        z1 /= 16.0f;
        x2 /= 16.0f;
        y2 /= 16.0f;
        z2 /= 16.0f;
        for (Direction face : this.drawFaces) {
            this.putFace(face, x1, y1, z1, x2, y2, z2);
        }
    }

    public void addQuad(Direction face, float x1, float y1, float z1, float x2, float y2, float z2) {
        this.putFace(face, x1, y1, z1, x2, y2, z2);
    }

    private void putFace(Direction face, float x1, float y1, float z1, float x2, float y2, float z2) {
        TextureAtlasSprite texture = this.textures.get(face);
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(this.output::add);
        builder.setSprite(texture);
        builder.setDirection(face);
        builder.setTintIndex(-1);
        builder.setShade(true);
        UvVector uv = new UvVector();
        Vector4f customUv = this.customUv.get(face);
        if (customUv != null) {
            uv.u1 = texture.m_118367_((double)customUv.m_123601_());
            uv.v1 = texture.m_118393_((double)customUv.m_123615_());
            uv.u2 = texture.m_118367_((double)customUv.m_123616_());
            uv.v2 = texture.m_118393_((double)customUv.m_123617_());
        } else {
            uv = this.useStandardUV ? this.getStandardUv(face, texture, x1, y1, z1, x2, y2, z2) : this.getDefaultUv(face, texture, x1, y1, z1, x2, y2, z2);
        }
        switch (face) {
            case DOWN: {
                this.putVertexBL(builder, face, x1, y1, z2, uv);
                this.putVertexTL(builder, face, x1, y1, z1, uv);
                this.putVertexTR(builder, face, x2, y1, z1, uv);
                this.putVertexBR(builder, face, x2, y1, z2, uv);
                break;
            }
            case UP: {
                this.putVertexTL(builder, face, x1, y2, z1, uv);
                this.putVertexBL(builder, face, x1, y2, z2, uv);
                this.putVertexBR(builder, face, x2, y2, z2, uv);
                this.putVertexTR(builder, face, x2, y2, z1, uv);
                break;
            }
            case NORTH: {
                this.putVertexBR(builder, face, x2, y2, z1, uv);
                this.putVertexTR(builder, face, x2, y1, z1, uv);
                this.putVertexTL(builder, face, x1, y1, z1, uv);
                this.putVertexBL(builder, face, x1, y2, z1, uv);
                break;
            }
            case SOUTH: {
                this.putVertexBL(builder, face, x1, y2, z2, uv);
                this.putVertexTL(builder, face, x1, y1, z2, uv);
                this.putVertexTR(builder, face, x2, y1, z2, uv);
                this.putVertexBR(builder, face, x2, y2, z2, uv);
                break;
            }
            case WEST: {
                this.putVertexBL(builder, face, x1, y2, z1, uv);
                this.putVertexTL(builder, face, x1, y1, z1, uv);
                this.putVertexTR(builder, face, x1, y1, z2, uv);
                this.putVertexBR(builder, face, x1, y2, z2, uv);
                break;
            }
            case EAST: {
                this.putVertexBL(builder, face, x2, y2, z2, uv);
                this.putVertexTL(builder, face, x2, y1, z2, uv);
                this.putVertexTR(builder, face, x2, y1, z1, uv);
                this.putVertexBR(builder, face, x2, y2, z1, uv);
            }
        }
    }

    private UvVector getDefaultUv(Direction face, TextureAtlasSprite texture, float x1, float y1, float z1, float x2, float y2, float z2) {
        UvVector uv = new UvVector();
        switch (face) {
            case DOWN: {
                uv.u1 = texture.m_118367_((double)(x1 * 16.0f));
                uv.v1 = texture.m_118393_((double)(z1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(x2 * 16.0f));
                uv.v2 = texture.m_118393_((double)(z2 * 16.0f));
                break;
            }
            case UP: {
                uv.u1 = texture.m_118367_((double)(x1 * 16.0f));
                uv.v1 = texture.m_118393_((double)(z1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(x2 * 16.0f));
                uv.v2 = texture.m_118393_((double)(z2 * 16.0f));
                break;
            }
            case NORTH: {
                uv.u1 = texture.m_118367_((double)(x1 * 16.0f));
                uv.v1 = texture.m_118393_((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(x2 * 16.0f));
                uv.v2 = texture.m_118393_((double)(16.0f - y2 * 16.0f));
                break;
            }
            case SOUTH: {
                uv.u1 = texture.m_118367_((double)(x1 * 16.0f));
                uv.v1 = texture.m_118393_((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(x2 * 16.0f));
                uv.v2 = texture.m_118393_((double)(16.0f - y2 * 16.0f));
                break;
            }
            case WEST: {
                uv.u1 = texture.m_118367_((double)(z1 * 16.0f));
                uv.v1 = texture.m_118393_((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(z2 * 16.0f));
                uv.v2 = texture.m_118393_((double)(16.0f - y2 * 16.0f));
                break;
            }
            case EAST: {
                uv.u1 = texture.m_118367_((double)(z2 * 16.0f));
                uv.v1 = texture.m_118393_((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(z1 * 16.0f));
                uv.v2 = texture.m_118393_((double)(16.0f - y2 * 16.0f));
            }
        }
        return uv;
    }

    private UvVector getStandardUv(Direction face, TextureAtlasSprite texture, float x1, float y1, float z1, float x2, float y2, float z2) {
        UvVector uv = new UvVector();
        switch (face) {
            case DOWN: {
                uv.u1 = texture.m_118367_((double)(x1 * 16.0f));
                uv.v1 = texture.m_118393_((double)(16.0f - z1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(x2 * 16.0f));
                uv.v2 = texture.m_118393_((double)(16.0f - z2 * 16.0f));
                break;
            }
            case UP: {
                uv.u1 = texture.m_118367_((double)(x1 * 16.0f));
                uv.v1 = texture.m_118393_((double)(z1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(x2 * 16.0f));
                uv.v2 = texture.m_118393_((double)(z2 * 16.0f));
                break;
            }
            case NORTH: {
                uv.u1 = texture.m_118367_((double)(16.0f - x1 * 16.0f));
                uv.v1 = texture.m_118393_((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(16.0f - x2 * 16.0f));
                uv.v2 = texture.m_118393_((double)(16.0f - y2 * 16.0f));
                break;
            }
            case SOUTH: {
                uv.u1 = texture.m_118367_((double)(x1 * 16.0f));
                uv.v1 = texture.m_118393_((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(x2 * 16.0f));
                uv.v2 = texture.m_118393_((double)(16.0f - y2 * 16.0f));
                break;
            }
            case WEST: {
                uv.u1 = texture.m_118367_((double)(z1 * 16.0f));
                uv.v1 = texture.m_118393_((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(z2 * 16.0f));
                uv.v2 = texture.m_118393_((double)(16.0f - y2 * 16.0f));
                break;
            }
            case EAST: {
                uv.u1 = texture.m_118367_((double)(16.0f - z2 * 16.0f));
                uv.v1 = texture.m_118393_((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.m_118367_((double)(16.0f - z1 * 16.0f));
                uv.v2 = texture.m_118393_((double)(16.0f - y2 * 16.0f));
            }
        }
        return uv;
    }

    private void putVertexTL(QuadBakingVertexConsumer builder, Direction face, float x, float y, float z, UvVector uv) {
        float u;
        this.putVertex(builder, face, x, y, z, u, switch (this.uvRotations[face.ordinal()]) {
            default -> {
                u = uv.u1;
                yield uv.v1;
            }
            case 1 -> {
                u = uv.u1;
                yield uv.v2;
            }
            case 2 -> {
                u = uv.u2;
                yield uv.v2;
            }
            case 3 -> {
                u = uv.u2;
                yield uv.v1;
            }
        });
    }

    private void putVertexTR(QuadBakingVertexConsumer builder, Direction face, float x, float y, float z, UvVector uv) {
        float u;
        this.putVertex(builder, face, x, y, z, u, switch (this.uvRotations[face.ordinal()]) {
            default -> {
                u = uv.u2;
                yield uv.v1;
            }
            case 1 -> {
                u = uv.u1;
                yield uv.v1;
            }
            case 2 -> {
                u = uv.u1;
                yield uv.v2;
            }
            case 3 -> {
                u = uv.u2;
                yield uv.v2;
            }
        });
    }

    private void putVertexBR(QuadBakingVertexConsumer builder, Direction face, float x, float y, float z, UvVector uv) {
        float u;
        this.putVertex(builder, face, x, y, z, u, switch (this.uvRotations[face.ordinal()]) {
            default -> {
                u = uv.u2;
                yield uv.v2;
            }
            case 1 -> {
                u = uv.u2;
                yield uv.v1;
            }
            case 2 -> {
                u = uv.u1;
                yield uv.v1;
            }
            case 3 -> {
                u = uv.u1;
                yield uv.v2;
            }
        });
    }

    private void putVertexBL(QuadBakingVertexConsumer builder, Direction face, float x, float y, float z, UvVector uv) {
        float u;
        this.putVertex(builder, face, x, y, z, u, switch (this.uvRotations[face.ordinal()]) {
            default -> {
                u = uv.u1;
                yield uv.v2;
            }
            case 1 -> {
                u = uv.u2;
                yield uv.v2;
            }
            case 2 -> {
                u = uv.u2;
                yield uv.v1;
            }
            case 3 -> {
                u = uv.u1;
                yield uv.v1;
            }
        });
    }

    private void putVertex(QuadBakingVertexConsumer builder, Direction face, float x, float y, float z, float u, float v) {
        builder.m_5483_((double)x, (double)y, (double)z);
        builder.m_5601_((float)face.m_122429_(), (float)face.m_122430_(), (float)face.m_122431_());
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        float a = (float)(this.color >> 24 & 0xFF) / 255.0f;
        builder.m_85950_(r, g, b, a);
        builder.m_7421_(u, v);
        if (this.emissiveMaterial) {
            builder.m_7120_(480, 480);
        }
        builder.m_5752_();
    }

    public void setTexture(TextureAtlasSprite texture) {
        for (Direction face : Direction.values()) {
            this.textures.put(face, texture);
        }
    }

    public void setTextures(TextureAtlasSprite up, TextureAtlasSprite down, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite east, TextureAtlasSprite west) {
        this.textures.put(Direction.UP, up);
        this.textures.put(Direction.DOWN, down);
        this.textures.put(Direction.NORTH, north);
        this.textures.put(Direction.SOUTH, south);
        this.textures.put(Direction.EAST, east);
        this.textures.put(Direction.WEST, west);
    }

    public void setTexture(Direction facing, TextureAtlasSprite sprite) {
        this.textures.put(facing, sprite);
    }

    public void setDrawFaces(EnumSet<Direction> drawFaces) {
        this.drawFaces = drawFaces;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColorRGB(int color) {
        this.setColor(color | 0xFF000000);
    }

    public void setColorRGB(float r, float g, float b) {
        this.setColorRGB((int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f));
    }

    public void setEmissiveMaterial(boolean renderFullBright) {
        this.emissiveMaterial = renderFullBright;
    }

    public void setCustomUv(Direction facing, float u1, float v1, float u2, float v2) {
        this.customUv.put(facing, new Vector4f(u1, v1, u2, v2));
    }

    public void setUvRotation(Direction facing, int rotation) {
        if (rotation == 2) {
            rotation = 3;
        } else if (rotation == 3) {
            rotation = 2;
        }
        Preconditions.checkArgument((rotation >= 0 && rotation <= 3 ? 1 : 0) != 0, (Object)"rotation");
        this.uvRotations[facing.ordinal()] = (byte)rotation;
    }

    public void useStandardUV() {
        this.useStandardUV = true;
    }

    public List<BakedQuad> getOutput() {
        return this.output;
    }

    private static final class UvVector {
        float u1;
        float u2;
        float v1;
        float v2;

        private UvVector() {
        }
    }
}

