/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.parts.CableRenderMode;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.stacks.AEKeyTypesInternal;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.FacadeItemGroup;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.hooks.SkyStoneBreakSpeed;
import appeng.hooks.WrenchHook;
import appeng.hooks.ticking.TickHandler;
import appeng.init.InitBlockEntities;
import appeng.init.InitBlocks;
import appeng.init.InitCapabilities;
import appeng.init.InitDispenserBehavior;
import appeng.init.InitEntityTypes;
import appeng.init.InitItems;
import appeng.init.InitMenuTypes;
import appeng.init.InitRecipeSerializers;
import appeng.init.InitRecipeTypes;
import appeng.init.InitVillager;
import appeng.init.client.InitParticleTypes;
import appeng.init.internal.InitGridLinkables;
import appeng.init.internal.InitP2PAttunements;
import appeng.init.internal.InitStorageCells;
import appeng.init.internal.InitUpgrades;
import appeng.init.worldgen.InitBiomes;
import appeng.init.worldgen.InitDimensionTypes;
import appeng.init.worldgen.InitStructures;
import appeng.integration.Integrations;
import appeng.items.tools.MemoryCardItem;
import appeng.items.tools.NetworkToolItem;
import appeng.server.AECommand;
import appeng.server.services.ChunkLoadingService;
import appeng.server.testworld.GameTestPlotAdapter;
import appeng.spatial.SpatialStorageChunkGenerator;
import appeng.spatial.SpatialStorageDimensionIds;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterGameTestsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class AppEngBase
implements AppEng {
    private final ThreadLocal<Player> partInteractionPlayer = new ThreadLocal();
    static AppEngBase INSTANCE;

    public AppEngBase() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
        InitGridLinkables.init();
        InitStorageCells.init();
        FacadeItemGroup.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::registerRegistries);
        modEventBus.addListener(event -> {
            if (!event.getRegistryKey().equals((Object)Registry.f_122901_)) {
                return;
            }
            InitBiomes.init((IForgeRegistry<Biome>)ForgeRegistries.BIOMES);
            InitBlocks.init((IForgeRegistry<Block>)ForgeRegistries.BLOCKS);
            InitItems.init((IForgeRegistry<Item>)ForgeRegistries.ITEMS);
            InitEntityTypes.init(ForgeRegistries.ENTITY_TYPES);
            InitParticleTypes.init(ForgeRegistries.PARTICLE_TYPES);
            InitBlockEntities.init(ForgeRegistries.BLOCK_ENTITY_TYPES);
            InitMenuTypes.init(ForgeRegistries.MENU_TYPES);
            InitRecipeTypes.init(ForgeRegistries.RECIPE_TYPES);
            InitRecipeSerializers.init(ForgeRegistries.RECIPE_SERIALIZERS);
            InitStructures.init();
            this.registerKeyTypes();
            InitVillager.init();
        });
        modEventBus.addListener(InitCapabilities::init);
        modEventBus.addListener(Integrations::enqueueIMC);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerTests);
        TickHandler.instance().init();
        MinecraftForge.EVENT_BUS.addListener(this::onServerAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(WrenchHook::onPlayerUseBlockEvent);
        MinecraftForge.EVENT_BUS.addListener(SkyStoneBreakSpeed::handleBreakFaster);
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, InitCapabilities::registerGenericInvWrapper);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, event -> {
            if (event.getItemStack().m_41720_() instanceof MemoryCardItem && event.getEntity().m_36341_()) {
                event.setUseBlock(Event.Result.ALLOW);
            }
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(this::postRegistrationInitialization).whenComplete((res, err) -> {
            if (err != null) {
                AELog.warn(err);
            }
        });
    }

    public void postRegistrationInitialization() {
        InitP2PAttunements.init();
        InitDispenserBehavior.init();
        AEConfig.instance().save();
        InitUpgrades.init();
        NetworkHandler.init(new ResourceLocation("ae2", "main"));
        ChunkLoadingService.register();
    }

    public void registerKeyTypes() {
        AEKeyTypes.register(AEKeyType.items());
        AEKeyTypes.register(AEKeyType.fluids());
    }

    public void registerCommands(ServerStartingEvent evt) {
        CommandDispatcher dispatcher = evt.getServer().m_129892_().m_82094_();
        new AECommand().register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    public void registerRegistries(NewRegistryEvent e) {
        InitDimensionTypes.init();
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)SpatialStorageDimensionIds.CHUNK_GENERATOR_ID, SpatialStorageChunkGenerator.CODEC);
        Supplier supplier = e.create(new RegistryBuilder().setMaxID(127).setName(AppEng.makeId("keytypes")));
        AEKeyTypesInternal.setRegistry(supplier);
    }

    private void onServerAboutToStart(ServerAboutToStartEvent evt) {
        ChunkLoadingService.getInstance().onServerAboutToStart(evt);
    }

    private void serverStopping(ServerStoppingEvent event) {
        ChunkLoadingService.getInstance().onServerStopping(event);
    }

    private void serverStopped(ServerStoppedEvent event) {
        TickHandler.instance().shutdown();
    }

    @Override
    public Collection<ServerPlayer> getPlayers() {
        MinecraftServer server = this.getCurrentServer();
        if (server != null) {
            return server.m_6846_().m_11314_();
        }
        return Collections.emptyList();
    }

    @Override
    public void sendToAllNearExcept(Player p, double x, double y, double z, double dist, Level level, BasePacket packet) {
        if (level.m_5776_()) {
            return;
        }
        for (ServerPlayer o : this.getPlayers()) {
            double dZ;
            double dY;
            double dX;
            if (o == p || o.f_19853_ != level || !((dX = x - o.m_20185_()) * dX + (dY = y - o.m_20186_()) * dY + (dZ = z - o.m_20189_()) * dZ < dist * dist)) continue;
            NetworkHandler.instance().sendTo(packet, o);
        }
    }

    @Override
    public void setPartInteractionPlayer(Player player) {
        this.partInteractionPlayer.set(player);
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        return this.getCableRenderModeForPlayer(this.partInteractionPlayer.get());
    }

    @Override
    @Nullable
    public MinecraftServer getCurrentServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    protected final CableRenderMode getCableRenderModeForPlayer(@Nullable Player player) {
        if (player != null) {
            for (int x = 0; x < Inventory.m_36059_(); ++x) {
                CompoundTag c;
                ItemStack is = player.m_150109_().m_8020_(x);
                if (is.m_41619_() || !(is.m_41720_() instanceof NetworkToolItem) || (c = is.m_41783_()) == null || !c.m_128471_("hideFacades")) continue;
                return CableRenderMode.CABLE_VIEW;
            }
        }
        return CableRenderMode.STANDARD;
    }

    private void registerTests(RegisterGameTestsEvent e) {
        if ("true".equals(System.getProperty("appeng.tests"))) {
            e.register(GameTestPlotAdapter.class);
        }
    }
}

