/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.ai;

import alexthw.ars_elemental.common.entity.MermaidEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RandomSwim;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.ai.behavior.RunSometimes;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.TryFindWater;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;

public class MermaidAi {
    private static final float SPEED_MULTIPLIER_ON_LAND = 0.15f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING_IN_WATER = 0.5f;
    private static final float SPEED_MULTIPLIER_WHEN_CHASING_IN_WATER = 0.6f;

    public static Brain<?> makeBrain(Brain<MermaidEntity> p_149291_) {
        MermaidAi.initCoreActivity(p_149291_);
        MermaidAi.initIdleActivity(p_149291_);
        p_149291_.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        p_149291_.m_21944_(Activity.f_37979_);
        p_149291_.m_21962_();
        return p_149291_;
    }

    private static void initCoreActivity(Brain<MermaidEntity> p_149307_) {
        p_149307_.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<MermaidEntity> p_149309_) {
        p_149309_.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimes((Behavior)new SetEntityLookTarget(EntityType.f_20532_, 6.0f), UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)3, (Object)new StartAttacking(MermaidAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)3, (Object)new TryFindWater(6, 0.15f)), (Object)Pair.of((Object)4, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)new RandomSwim(0.5f), (Object)2), (Object)Pair.of((Object)new RandomStroll(0.15f, false), (Object)2), (Object)Pair.of((Object)new SetWalkTargetFromLookTarget(MermaidAi::canSetWalkTargetFromLookTarget, MermaidAi::getSpeedModifier, 3), (Object)3), (Object)Pair.of((Object)new RunIf(Entity::m_20072_, (Behavior)new DoNothing(30, 60)), (Object)5), (Object)Pair.of((Object)new RunIf(Entity::m_20096_, (Behavior)new DoNothing(200, 400)), (Object)5))))));
    }

    private static boolean canSetWalkTargetFromLookTarget(LivingEntity p_182381_) {
        Level level = p_182381_.f_19853_;
        Optional optional = p_182381_.m_6274_().m_21952_(MemoryModuleType.f_26371_);
        if (optional.isPresent()) {
            BlockPos blockpos = ((PositionTracker)optional.get()).m_6675_();
            return level.m_46801_(blockpos) == p_182381_.m_20072_();
        }
        return false;
    }

    public static void updateActivity(MermaidEntity p_149293_) {
        Brain<MermaidEntity> brain = p_149293_.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37979_));
        if (activity == Activity.f_37988_ && brain.m_21968_().orElse(null) != Activity.f_37988_) {
            brain.m_21882_(MemoryModuleType.f_148201_, (Object)true, 2400L);
        }
    }

    private static float getSpeedModifierChasing(LivingEntity p_149289_) {
        return p_149289_.m_20072_() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifier(LivingEntity p_149301_) {
        return p_149301_.m_20072_() ? 0.5f : 0.15f;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(MermaidEntity p_149299_) {
        return p_149299_.m_6274_().m_21952_(MemoryModuleType.f_148194_);
    }
}

