/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.common.entity.spells.EntityHomingProjectile;
import alexthw.ars_elemental.registry.ModAdvTriggers;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.items.EnchantersShield;
import com.hollingsworth.arsnouveau.common.spell.casters.ReactiveCaster;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_elemental")
public class ShieldEvents {
    @SubscribeEvent
    public static void onBlock(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof EntityProjectileSpell) {
            int level;
            ItemStack stack;
            Player player;
            EntityHitResult result;
            EntityProjectileSpell projectileSpell = (EntityProjectileSpell)projectile;
            projectile = event.getRayTraceResult();
            if (projectile instanceof EntityHitResult && (projectile = (result = (EntityHitResult)projectile).m_82443_()) instanceof Player && (player = (Player)projectile).m_21254_() && (stack = player.m_21206_()).m_41720_() instanceof EnchantersShield && (double)(level = stack.getEnchantmentLevel((Enchantment)ModRegistry.MIRROR.get())) * 0.25 >= Math.random()) {
                projectileSpell.m_20256_(projectileSpell.m_20184_().m_82548_().m_82520_(0.0, 0.2, 0.0));
                if (projectileSpell instanceof EntityHomingProjectile) {
                    EntityHomingProjectile homing = (EntityHomingProjectile)projectileSpell;
                    if (level > 3) {
                        homing.getIgnored().add(e -> e == player);
                    }
                }
                if (player instanceof ServerPlayer) {
                    ModAdvTriggers.MIRROR.m_222618_((ServerPlayer)player);
                    float pay = (float)projectileSpell.spellResolver.getResolveCost() / ((float)level * 2.0f);
                    CapabilityRegistry.getMana((LivingEntity)player).ifPresent(mana -> mana.removeMana((double)pay));
                    player.m_36335_().m_41524_(stack.m_41720_(), 20 * level);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockReactive(ShieldBlockEvent event) {
        Player player;
        block5: {
            block4: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block4;
                player = (Player)livingEntity;
                if (!player.m_20193_().f_46443_) break block5;
            }
            return;
        }
        ItemStack s = player.m_21206_();
        if (s.m_41720_() instanceof EnchantersShield && (double)s.getEnchantmentLevel((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT.get()) * 0.25 >= Math.random() && new ReactiveCaster(s).getSpell().isValid()) {
            ReactiveCaster reactiveCaster = new ReactiveCaster(s);
            reactiveCaster.castSpell(player.m_20193_(), player, InteractionHand.OFF_HAND, null);
        }
    }
}

