/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.cpu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.SimulationDescription;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base.BaseReactorSimulation;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base.SimUtil;
import net.roguelogix.biggerreactors.registries.ReactorModeratorRegistry;

public class TimeSlicedReactorSimulation
extends BaseReactorSimulation {
    private int currentRod = 0;
    private int rodOffset = 0;

    public TimeSlicedReactorSimulation(SimulationDescription simulationDescription) {
        super(simulationDescription);
        Collections.shuffle(Arrays.asList(this.controlRods), new Random());
    }

    @Override
    protected double radiate() {
        if (this.fuelTank.fuel() <= 0L) {
            return 0.0;
        }
        ++this.currentRod;
        if (this.currentRod >= this.controlRods.length) {
            this.currentRod = 0;
            ++this.rodOffset;
        }
        int yLevel = this.currentRod % this.y;
        int currentRod = this.currentRod + this.rodOffset;
        currentRod %= this.controlRods.length;
        double radiationPenaltyBase = Math.exp(-Config.CONFIG.Reactor.RadPenaltyShiftMultiplier * Math.exp(-0.001 * Config.CONFIG.Reactor.RadPenaltyRateMultiplier * (this.fuelHeat.temperature() - 273.15)));
        long baseFuelAmount = this.fuelTank.fuel() + this.fuelTank.waste() / 100L;
        double rawRadIntensity = (double)baseFuelAmount * Config.CONFIG.Reactor.FissionEventsPerFuelUnit;
        double scaledRadIntensity = Math.pow(Math.pow(rawRadIntensity, Config.CONFIG.Reactor.FuelReactivity) / (double)this.controlRods.length, Config.CONFIG.Reactor.FuelReactivity) * (double)this.controlRods.length;
        double initialHardness = Math.min(1.0, (double)0.2f + 0.8 * radiationPenaltyBase);
        double rawIntensity = 1.0 + -Config.CONFIG.Reactor.RadIntensityScalingMultiplier * Math.exp(-10.0 * Config.CONFIG.Reactor.RadIntensityScalingShiftMultiplier * Math.exp((double)-0.001f * Config.CONFIG.Reactor.RadIntensityScalingRateExponentMultiplier * (this.fuelHeat.temperature() - 273.15)));
        double fuelAbsorptionTemperatureCoefficient = 1.0 - Config.CONFIG.Reactor.FuelAbsorptionScalingMultiplier * Math.exp(-10.0 * Config.CONFIG.Reactor.FuelAbsorptionScalingShiftMultiplier * Math.exp(-0.001 * Config.CONFIG.Reactor.FuelAbsorptionScalingRateExponentMultiplier * (this.fuelHeat.temperature() - 273.15)));
        double fuelHardnessMultiplier = 1.0 / Config.CONFIG.Reactor.FuelHardnessDivisor;
        double rawFuelUsage = 0.0;
        double fuelRFAdded = 0.0;
        double fuelRadAdded = 0.0;
        double caseRFAdded = 0.0;
        double FuelPerRadiationUnit = Config.CONFIG.Reactor.FuelPerRadiationUnit;
        double FEPerRadiationUnit = Config.CONFIG.Reactor.FEPerRadiationUnit;
        double FuelUsageMultiplier = Config.CONFIG.Reactor.FuelUsageMultiplier;
        double FuelAbsorptionCoefficient = Config.CONFIG.Reactor.FuelAbsorptionCoefficient;
        double FuelModerationFactor = Config.CONFIG.Reactor.FuelModerationFactor;
        SimUtil.ControlRod rod = this.controlRods[currentRod];
        double controlRodModifier = (100.0 - rod.insertion) / 100.0;
        double effectiveRadIntensity = scaledRadIntensity * controlRodModifier;
        double effectiveRawRadIntensity = rawRadIntensity * controlRodModifier;
        double initialIntensity = effectiveRadIntensity * rawIntensity;
        rawFuelUsage += FuelPerRadiationUnit * effectiveRawRadIntensity / this.fertility() * FuelUsageMultiplier;
        fuelRFAdded += FEPerRadiationUnit * initialIntensity;
        double rayMultiplier = 1.0 / (double)SimUtil.rays.size();
        block0: for (int j = 0; j < SimUtil.rays.size(); ++j) {
            ArrayList<SimUtil.RayStep> raySteps = SimUtil.rays.get(j);
            double neutronHardness = initialHardness;
            double neutronIntensity = initialIntensity * rayMultiplier;
            for (int k = 0; k < raySteps.size(); ++k) {
                SimUtil.RayStep rayStep = raySteps.get(k);
                int currentX = rod.x + rayStep.offset.x;
                int currentY = yLevel + rayStep.offset.y;
                int currentZ = rod.z + rayStep.offset.z;
                if (currentX < 0 || currentX >= this.x || currentY < 0 || currentY >= this.y || currentZ < 0 || currentZ >= this.z) continue block0;
                ReactorModeratorRegistry.IModeratorProperties properties = this.moderatorProperties[currentX][currentY][currentZ];
                if (properties != null) {
                    double radiationAbsorbed = neutronIntensity * properties.absorption() * (1.0 - neutronHardness) * rayStep.length;
                    neutronIntensity = Math.max(0.0, neutronIntensity - radiationAbsorbed);
                    neutronHardness /= (properties.moderation() - 1.0) * rayStep.length + 1.0;
                    caseRFAdded += properties.heatEfficiency() * radiationAbsorbed * FEPerRadiationUnit;
                    continue;
                }
                double controlRodInsertion = this.controlRodsXZ[currentX][currentZ].insertion * 0.001;
                double baseAbsorption = fuelAbsorptionTemperatureCoefficient * (1.0 - neutronHardness * fuelHardnessMultiplier);
                double scaledAbsorption = baseAbsorption * FuelAbsorptionCoefficient * rayStep.length;
                double controlRodBonus = (1.0 - scaledAbsorption) * controlRodInsertion * 0.5;
                double controlRodPenalty = scaledAbsorption * controlRodInsertion * 0.5;
                double radiationAbsorbed = (scaledAbsorption + controlRodBonus) * neutronIntensity;
                double fertilityAbsorbed = (scaledAbsorption - controlRodPenalty) * neutronIntensity;
                double fuelModerationFactor = FuelModerationFactor + (FuelModerationFactor * controlRodInsertion + controlRodInsertion);
                neutronIntensity = Math.max(0.0, neutronIntensity - radiationAbsorbed);
                neutronHardness /= (fuelModerationFactor - 1.0) * rayStep.length + 1.0;
                fuelRFAdded += radiationAbsorbed * FEPerRadiationUnit;
                fuelRadAdded += fertilityAbsorbed;
            }
        }
        if (!Double.isNaN(fuelRadAdded)) {
            if (Config.CONFIG.Reactor.fuelRadScalingMultiplier != 0.0) {
                fuelRadAdded *= Config.CONFIG.Reactor.fuelRadScalingMultiplier * ((double)Config.CONFIG.Reactor.PerFuelRodCapacity / Math.max(1.0, (double)this.fuelTank().totalStored()));
            }
            this.fuelFertility += fuelRadAdded;
        }
        if (!Double.isNaN(fuelRFAdded)) {
            this.fuelHeat.absorbRF(fuelRFAdded);
        }
        if (!Double.isNaN(caseRFAdded)) {
            this.stackHeat.absorbRF(caseRFAdded);
        }
        return rawFuelUsage;
    }
}

