/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.turbine.deps;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.biggerreactors.multiblocks.turbine.TurbineMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.turbine.state.VentState;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;

public class TurbinePeripheral
implements IPeripheral {
    @Nonnull
    private final Supplier<TurbineMultiblockController> rawControllerSupplier;
    @Nonnull
    private final LamdbaExceptionUtils.Supplier_WithExceptions<TurbineMultiblockController, LuaException> controllerSupplier;
    private final Battery battery;
    private final Rotor rotor;
    private final FluidTank tank;

    public static LazyOptional<Object> create(@Nonnull Supplier<TurbineMultiblockController> controllerSupplier) {
        return LazyOptional.of(() -> new TurbinePeripheral(controllerSupplier));
    }

    public TurbinePeripheral(@Nonnull Supplier<TurbineMultiblockController> rawControllerSupplier) {
        this.rawControllerSupplier = rawControllerSupplier;
        this.controllerSupplier = this::getController;
        this.battery = new Battery(this.controllerSupplier);
        this.rotor = new Rotor(this.controllerSupplier);
        this.tank = new FluidTank(this.controllerSupplier);
    }

    @LuaFunction
    public String apiVersion() {
        return BiggerReactors.modVersion();
    }

    @LuaFunction
    public boolean connected() {
        if (this.rawControllerSupplier.get() == null) {
            return false;
        }
        return this.rawControllerSupplier.get().assemblyState() == MultiblockController.AssemblyState.ASSEMBLED;
    }

    @Nonnull
    private TurbineMultiblockController getController() throws LuaException {
        TurbineMultiblockController controller = this.rawControllerSupplier.get();
        if (controller == null || controller.assemblyState() != MultiblockController.AssemblyState.ASSEMBLED) {
            throw new LuaException("Invalid multiblock controller");
        }
        return controller;
    }

    @LuaFunction
    public boolean active() throws LuaException {
        return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().active();
    }

    @LuaFunction
    public void setActive(boolean active) throws LuaException {
        ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).setActive(active);
    }

    @LuaFunction
    public Battery battery() {
        return this.battery;
    }

    @LuaFunction
    public Rotor rotor() {
        return this.rotor;
    }

    @LuaFunction
    public FluidTank fluidTank() {
        return this.tank;
    }

    @LuaFunction
    public boolean coilEngaged() throws LuaException {
        return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().coilEngaged();
    }

    @LuaFunction
    public void setCoilEngaged(boolean engaged) throws LuaException {
        ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().setCoilEngaged(engaged);
    }

    @Nonnull
    public String getType() {
        return "BiggerReactors_Turbine";
    }

    public boolean equals(@Nullable IPeripheral other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TurbinePeripheral) {
            if (this.rawControllerSupplier.get() == null) {
                return false;
            }
            return ((TurbinePeripheral)other).rawControllerSupplier.get() == this.rawControllerSupplier.get();
        }
        return false;
    }

    public static class Battery {
        private final LamdbaExceptionUtils.Supplier_WithExceptions<TurbineMultiblockController, LuaException> controllerSupplier;

        public Battery(LamdbaExceptionUtils.Supplier_WithExceptions<TurbineMultiblockController, LuaException> controllerSupplier) {
            this.controllerSupplier = controllerSupplier;
        }

        @LuaFunction
        public long stored() throws LuaException {
            return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().battery().stored();
        }

        @LuaFunction
        public long capacity() throws LuaException {
            return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().battery().capacity();
        }

        @LuaFunction
        public long producedLastTick() throws LuaException {
            return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().FEGeneratedLastTick();
        }
    }

    public static class Rotor {
        private final LamdbaExceptionUtils.Supplier_WithExceptions<TurbineMultiblockController, LuaException> controllerSupplier;

        public Rotor(LamdbaExceptionUtils.Supplier_WithExceptions<TurbineMultiblockController, LuaException> controllerSupplier) {
            this.controllerSupplier = controllerSupplier;
        }

        @LuaFunction
        public double RPM() throws LuaException {
            return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().RPM();
        }

        @LuaFunction
        public double efficiencyLastTick() throws LuaException {
            return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().bladeEfficiencyLastTick();
        }
    }

    public static class FluidTank {
        private final LamdbaExceptionUtils.Supplier_WithExceptions<TurbineMultiblockController, LuaException> controllerSupplier;
        final TankFluid input;
        final TankFluid output;

        public FluidTank(LamdbaExceptionUtils.Supplier_WithExceptions<TurbineMultiblockController, LuaException> controllerSupplier) {
            this.controllerSupplier = controllerSupplier;
            this.input = new TankFluid(controllerSupplier, 0);
            this.output = new TankFluid(controllerSupplier, 1);
        }

        @LuaFunction
        public TankFluid input() {
            return this.input;
        }

        @LuaFunction
        public TankFluid output() {
            return this.output;
        }

        @LuaFunction
        public long flowLastTick() throws LuaException {
            return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().flowLastTick();
        }

        @LuaFunction
        public long nominalFlowRate() throws LuaException {
            return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().nominalFlowRate();
        }

        @LuaFunction
        public void setNominalFlowRate(long rate) throws LuaException {
            ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().setNominalFlowRate(rate);
        }

        @LuaFunction
        public long flowRateLimit() throws LuaException {
            return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().flowRateLimit();
        }

        public static class TankFluid {
            final LamdbaExceptionUtils.Supplier_WithExceptions<TurbineMultiblockController, LuaException> controllerSupplier;
            final int tankNum;

            public TankFluid(LamdbaExceptionUtils.Supplier_WithExceptions<TurbineMultiblockController, LuaException> controllerSupplier, int tankNum) {
                this.controllerSupplier = controllerSupplier;
                this.tankNum = tankNum;
            }

            @LuaFunction
            public String name() throws LuaException {
                return ForgeRegistries.FLUIDS.getKey((Object)((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().fluidTank().fluidTypeInTank(this.tankNum)).toString();
            }

            @LuaFunction
            public long amount() throws LuaException {
                return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().fluidTank().fluidAmountInTank(this.tankNum);
            }

            @LuaFunction
            public long maxAmount() throws LuaException {
                return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().fluidTank().perSideCapacity();
            }
        }
    }

    public static class Vent {
        private final LamdbaExceptionUtils.Supplier_WithExceptions<TurbineMultiblockController, LuaException> controllerSupplier;

        public Vent(LamdbaExceptionUtils.Supplier_WithExceptions<TurbineMultiblockController, LuaException> controllerSupplier) {
            this.controllerSupplier = controllerSupplier;
        }

        @LuaFunction
        public boolean closed() throws LuaException {
            return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().ventState() == VentState.CLOSED;
        }

        @LuaFunction
        public boolean overflow() throws LuaException {
            return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().ventState() == VentState.OVERFLOW;
        }

        @LuaFunction
        public boolean all() throws LuaException {
            return ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().ventState() == VentState.ALL;
        }

        @LuaFunction
        public void setClosed() throws LuaException {
            ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().setVentState(VentState.CLOSED);
        }

        @LuaFunction
        public void setOverflow() throws LuaException {
            ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().setVentState(VentState.OVERFLOW);
        }

        @LuaFunction
        public void setAll() throws LuaException {
            ((TurbineMultiblockController)((Object)this.controllerSupplier.get())).simulation().setVentState(VentState.ALL);
        }
    }
}

