/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.ldtteam.blockui.MatrixUtils;
import com.ldtteam.blockui.views.BOWindow;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ForgeRenderTypes;

public class BOScreen
extends Screen {
    protected double renderScale = 1.0;
    protected double mcScale = 1.0;
    protected BOWindow window;
    protected double x = 0.0;
    protected double y = 0.0;
    public static boolean isMouseLeftDown = false;
    protected boolean isOpen = false;

    public BOScreen(BOWindow w) {
        super((Component)Component.m_237113_((String)"Blockout GUI"));
        this.window = w;
    }

    public void m_6305_(PoseStack ms, int mx, int my, float f) {
        if (this.f_96541_ == null || !this.isOpen) {
            return;
        }
        double fbWidth = this.f_96541_.m_91268_().m_85441_();
        double fbHeight = this.f_96541_.m_91268_().m_85442_();
        double guiWidth = Math.max(fbWidth, 320.0);
        double guiHeight = Math.max(fbHeight, 240.0);
        float renderZlevel = MatrixUtils.getLastMatrixTranslateZ(ms);
        float oldZ = this.f_96541_.m_91291_().f_115093_;
        this.f_96541_.m_91291_().f_115093_ = renderZlevel;
        boolean oldFilteringValue = ForgeRenderTypes.enableTextTextureLinearFiltering;
        ForgeRenderTypes.enableTextTextureLinearFiltering = false;
        this.mcScale = this.f_96541_.m_91268_().m_85449_();
        this.renderScale = this.window.getRenderType().calcRenderScale(this.f_96541_.m_91268_(), this.window);
        if (this.window.hasLightbox()) {
            this.f_96543_ = (int)fbWidth;
            this.f_96544_ = (int)fbHeight;
            super.m_7333_(ms);
        }
        this.f_96543_ = this.window.getWidth();
        this.f_96544_ = this.window.getHeight();
        this.x = Math.floor((guiWidth - (double)this.f_96543_ * this.renderScale) / 2.0);
        this.y = Math.floor((guiHeight - (double)this.f_96544_ * this.renderScale) / 2.0);
        PoseStack shaderPs = RenderSystem.m_157191_();
        Matrix4f oldProjection = RenderSystem.m_157192_();
        RenderSystem.m_157425_((Matrix4f)Matrix4f.m_162203_((float)0.0f, (float)((float)fbWidth), (float)0.0f, (float)((float)fbHeight), (float)-10000.0f, (float)50000.0f));
        shaderPs.m_85836_();
        shaderPs.m_166856_();
        PoseStack newMs = new PoseStack();
        newMs.m_85837_(this.x, this.y, (double)renderZlevel);
        newMs.m_85841_((float)this.renderScale, (float)this.renderScale, 1.0f);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
        try {
            this.window.draw(newMs, this.calcRelativeX(mx), this.calcRelativeY(my));
            this.window.drawLast(newMs, this.calcRelativeX(mx), this.calcRelativeY(my));
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Rendering BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen rendering details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Scaling mode (window render type)", () -> this.window.getRenderType().name());
            category.m_128165_("Vanilla gui scale", () -> Double.toString(this.mcScale));
            category.m_128165_("BO gui scale", () -> Double.toString(this.renderScale));
            throw new ReportedException(crashReport);
        }
        finally {
            shaderPs.m_85849_();
            RenderSystem.m_157425_((Matrix4f)oldProjection);
            RenderSystem.m_157182_();
            this.f_96541_.m_91291_().f_115093_ = oldZ;
            ForgeRenderTypes.enableTextTextureLinearFiltering = oldFilteringValue;
        }
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (key >= 0 && key <= 348) {
            try {
                return this.window.onKeyTyped('\u0000', key);
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"KeyPressed event for BO screen");
                CrashReportCategory category = crashReport.m_127514_("BO screen key event details");
                category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.m_128165_("GLFW key value", () -> Integer.toString(key));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public boolean m_5534_(char ch, int key) {
        try {
            return this.window.onKeyTyped(ch, key);
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"CharTyped event for BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen char event details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Char value", () -> Character.toString(ch));
            throw new ReportedException(crashReport);
        }
    }

    public boolean m_6375_(double mxIn, double myIn, int keyCode) {
        double mx = this.calcRelativeX(mxIn);
        double my = this.calcRelativeY(myIn);
        try {
            if (keyCode == 0) {
                isMouseLeftDown = true;
                return this.window.click(mx, my);
            }
            if (keyCode == 1) {
                return this.window.rightClick(mx, my);
            }
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MousePressed event for BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen mouse event details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("GLFW mouse key value", () -> Integer.toString(keyCode));
            throw new ReportedException(crashReport);
        }
        return false;
    }

    public boolean m_6050_(double mx, double my, double scrollDiff) {
        if (scrollDiff != 0.0) {
            try {
                return this.window.scrollInput(scrollDiff * 10.0, this.calcRelativeX(mx), this.calcRelativeY(my));
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MouseScroll event for BO screen");
                CrashReportCategory category = crashReport.m_127514_("BO screen scroll event details");
                category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.m_128165_("Scroll value", () -> Double.toString(scrollDiff));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public boolean m_7979_(double xIn, double yIn, int speed, double deltaX, double deltaY) {
        try {
            return this.window.onMouseDrag(this.calcRelativeX(xIn), this.calcRelativeY(yIn), speed, deltaX, deltaY);
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MouseDragged event for BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen mouse event details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            throw new ReportedException(crashReport);
        }
    }

    public boolean m_6348_(double mxIn, double myIn, int keyCode) {
        if (keyCode == 0) {
            isMouseLeftDown = false;
            try {
                return this.window.onMouseReleased(this.calcRelativeX(mxIn), this.calcRelativeY(myIn));
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"MouseReleased event for BO screen");
                CrashReportCategory category = crashReport.m_127514_("BO screen mouse event details");
                category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
                category.m_128165_("GLFW mouse key value", () -> Integer.toString(keyCode));
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }

    public void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
    }

    public BOWindow getWindow() {
        return this.window;
    }

    public void m_86600_() {
        try {
            if (this.f_96541_ != null) {
                if (!this.isOpen) {
                    this.window.onOpened();
                    this.isOpen = true;
                } else {
                    this.window.onUpdate();
                    if (!this.f_96541_.f_91074_.m_6084_() || this.f_96541_.f_91074_.f_20890_) {
                        this.f_96541_.f_91074_.m_6915_();
                    }
                }
            }
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Ticking/Updating BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen update details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Is opened", () -> Boolean.toString(this.isOpen));
            throw new ReportedException(crashReport);
        }
    }

    public void m_7861_() {
        try {
            this.window.onClosed();
        }
        catch (Exception e) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Closing BO screen");
            CrashReportCategory category = crashReport.m_127514_("BO screen closing details");
            category.m_128165_("XML res loc", () -> this.window.getXmlResourceLocation().toString());
            category.m_128165_("Is opened", () -> Boolean.toString(this.isOpen));
            throw new ReportedException(crashReport);
        }
        finally {
            BOWindow.clearFocus();
            this.f_96541_.f_91068_.m_90926_(false);
        }
    }

    public boolean m_7043_() {
        return this.window.doesWindowPauseGame();
    }

    private double calcRelativeX(double xIn) {
        return (xIn * this.mcScale - this.x) / this.renderScale;
    }

    private double calcRelativeY(double yIn) {
        return (yIn * this.mcScale - this.y) / this.renderScale;
    }

    public double getRenderScale() {
        return this.renderScale;
    }

    public double getVanillaGuiScale() {
        return this.mcScale;
    }
}

