/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client;

import com.direwolf20.buildinggadgets.client.KeyBindings;
import com.direwolf20.buildinggadgets.client.cache.CacheTemplateProvider;
import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.client.renderer.EffectBlockTER;
import com.direwolf20.buildinggadgets.client.screen.TemplateManagerGUI;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlock;
import com.direwolf20.buildinggadgets.common.blocks.OurBlocks;
import com.direwolf20.buildinggadgets.common.containers.OurContainers;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.tileentities.OurTileEntities;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientProxy.class);
    public static final CacheTemplateProvider CACHE_TEMPLATE_PROVIDER = new CacheTemplateProvider();

    public static void clientSetup() {
        LOGGER.debug("Setting up client for {}", (Object)"buildinggadgets");
        KeyBindings.init();
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)OurTileEntities.EFFECT_BLOCK_TILE_ENTITY.get()), EffectBlockTER::new);
        MenuScreens.m_96206_((MenuType)((MenuType)OurContainers.TEMPLATE_MANAGER_CONTAINER.get()), TemplateManagerGUI::new);
        MinecraftForge.EVENT_BUS.addListener(ClientProxy::onPlayerLoggedOut);
        CACHE_TEMPLATE_PROVIDER.registerUpdateListener(((GadgetCopyPaste)((Object)OurItems.COPY_PASTE_GADGET_ITEM.get())).getRender());
    }

    @SubscribeEvent
    public static void registerConstructionBlockColorHandler(RegisterColorHandlersEvent.Block event) {
        LOGGER.debug("Registering color handlers for {}", (Object)"buildinggadgets");
        event.register((state, world, pos, tintIndex) -> {
            if (world != null) {
                BlockState mimicBlock = ConstructionBlock.getActualMimicBlock((BlockGetter)world, pos);
                if (mimicBlock == null) {
                    return -1;
                }
                try {
                    return event.getBlockColors().m_92577_(mimicBlock, world, pos, tintIndex);
                }
                catch (Exception var8) {
                    return -1;
                }
            }
            return -1;
        }, new Block[]{(Block)OurBlocks.CONSTRUCTION_BLOCK.get()});
    }

    @SubscribeEvent
    public static void registerTooltipFactory(RegisterClientTooltipComponentFactoriesEvent event) {
        LOGGER.debug("Registering custom tooltip component factories for {}", (Object)"buildinggadgets");
        event.register(EventTooltip.CopyPasteTooltipComponent.Data.class, EventTooltip.CopyPasteTooltipComponent::new);
    }

    @SubscribeEvent
    public static void registerSprites(TextureStitchEvent.Pre event) {
        LOGGER.debug("Registering pre texture stitching events for {}", (Object)"buildinggadgets");
        event.addSprite(new ResourceLocation("buildinggadgets:gui/slot_copy_paste_gadget"));
        event.addSprite(new ResourceLocation("buildinggadgets:gui/slot_template"));
    }

    public static void playSound(SoundEvent sound, float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)pitch));
    }

    private static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        CACHE_TEMPLATE_PROVIDER.clear();
    }

    @SubscribeEvent
    public static void bakeModels(ModelEvent.BakingCompleted event) {
        LOGGER.debug("Registering baked models for {}", (Object)"buildinggadgets");
        ResourceLocation ConstrName = new ResourceLocation("buildinggadgets", "construction_block");
        final TextureAtlasSprite breakPart = Minecraft.m_91087_().m_91289_().m_110910_(Blocks.f_50069_.m_49966_()).m_6160_();
        ModelResourceLocation ConstrLocation1 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=false,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation1a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=false,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation2 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=true,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation2a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=true,neighbor_brightness=false");
        ModelResourceLocation ConstrLocation3 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=false,neighbor_brightness=true");
        ModelResourceLocation ConstrLocation3a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=false,neighbor_brightness=true");
        ModelResourceLocation ConstrLocation4 = new ModelResourceLocation(ConstrName, "ambient_occlusion=false,bright=true,neighbor_brightness=true");
        ModelResourceLocation ConstrLocation4a = new ModelResourceLocation(ConstrName, "ambient_occlusion=true,bright=true,neighbor_brightness=true");
        IDynamicBakedModel bakedModelLoader = new IDynamicBakedModel(){

            public boolean m_7539_() {
                return false;
            }

            public boolean m_7547_() {
                return false;
            }

            public boolean m_7521_() {
                return false;
            }

            public boolean m_7541_() {
                return true;
            }

            public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, RenderType type) {
                BlockState facadeState = (BlockState)modelData.get(ConstructionBlockTileEntity.FACADE_STATE);
                if (facadeState == null || facadeState == Blocks.f_50016_.m_49966_()) {
                    facadeState = ((Block)OurBlocks.CONSTRUCTION_DENSE_BLOCK.get()).m_49966_();
                }
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(facadeState);
                if (type != null && !model.getRenderTypes(facadeState, rand, modelData).contains(type)) {
                    return Collections.emptyList();
                }
                return model.getQuads(facadeState, side, rand, modelData, type);
            }

            public TextureAtlasSprite m_6160_() {
                return breakPart;
            }

            public ItemOverrides m_7343_() {
                return null;
            }

            @Nonnull
            public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
                return tileData;
            }

            public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
                return ChunkRenderTypeSet.all();
            }
        };
        IDynamicBakedModel bakedModelLoaderAmbient = new IDynamicBakedModel(){

            public boolean m_7539_() {
                return false;
            }

            public boolean m_7547_() {
                return false;
            }

            public boolean m_7521_() {
                return false;
            }

            public boolean m_7541_() {
                return true;
            }

            public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, RenderType type) {
                BlockState facadeState = (BlockState)modelData.get(ConstructionBlockTileEntity.FACADE_STATE);
                if (facadeState == null || facadeState == Blocks.f_50016_.m_49966_()) {
                    facadeState = ((Block)OurBlocks.CONSTRUCTION_DENSE_BLOCK.get()).m_49966_();
                }
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(facadeState);
                if (type != null && !model.getRenderTypes(facadeState, rand, modelData).contains(type)) {
                    return Collections.emptyList();
                }
                return model.getQuads(facadeState, side, rand, modelData, type);
            }

            public TextureAtlasSprite m_6160_() {
                return breakPart;
            }

            public ItemOverrides m_7343_() {
                return null;
            }

            @Nonnull
            public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
                return tileData;
            }

            public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
                return ChunkRenderTypeSet.all();
            }
        };
        event.getModels().put(ConstrLocation1, bakedModelLoader);
        event.getModels().put(ConstrLocation2, bakedModelLoader);
        event.getModels().put(ConstrLocation3, bakedModelLoader);
        event.getModels().put(ConstrLocation4, bakedModelLoader);
        event.getModels().put(ConstrLocation1a, bakedModelLoaderAmbient);
        event.getModels().put(ConstrLocation2a, bakedModelLoaderAmbient);
        event.getModels().put(ConstrLocation3a, bakedModelLoaderAmbient);
        event.getModels().put(ConstrLocation4a, bakedModelLoaderAmbient);
    }
}

