/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.network.play;

import com.mrcrayfish.furniture.common.mail.Mail;
import com.mrcrayfish.furniture.common.mail.PostOffice;
import com.mrcrayfish.furniture.inventory.container.CrateMenu;
import com.mrcrayfish.furniture.inventory.container.PostBoxMenu;
import com.mrcrayfish.furniture.network.message.C2SMessageLockCrate;
import com.mrcrayfish.furniture.network.message.C2SMessageOpenMailBox;
import com.mrcrayfish.furniture.network.message.C2SMessageSendMail;
import com.mrcrayfish.furniture.network.message.C2SMessageSetDoorMat;
import com.mrcrayfish.furniture.network.message.C2SMessageSetMailBoxName;
import com.mrcrayfish.furniture.tileentity.CrateBlockEntity;
import com.mrcrayfish.furniture.tileentity.DoorMatBlockEntity;
import com.mrcrayfish.furniture.tileentity.MailBoxBlockEntity;
import com.mrcrayfish.furniture.util.BlockEntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkHooks;

public class ServerPlayHandler {
    public static void handleLockCrateMessage(ServerPlayer player, C2SMessageLockCrate message) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof CrateMenu)) {
            return;
        }
        CrateMenu crateMenu = (CrateMenu)abstractContainerMenu;
        CrateBlockEntity crate = crateMenu.getBlockEntity();
        if (crate == null) {
            return;
        }
        if (crate.getOwner() == null) {
            crate.setOwner(player.m_20148_());
        }
        if (player.m_20148_().equals(crate.getOwner())) {
            crate.setLocked(!crate.isLocked());
            crate.removeUnauthorisedPlayers();
        }
    }

    public static void handleOpenMailBoxMessage(ServerPlayer player, C2SMessageOpenMailBox message) {
        ServerLevel level = player.m_9236_();
        if (!level.m_46749_(message.getPos())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(message.getPos());
        if (!(blockEntity instanceof MailBoxBlockEntity)) {
            return;
        }
        MailBoxBlockEntity blockEntity2 = (MailBoxBlockEntity)blockEntity;
        if (!blockEntity2.m_6542_((Player)player)) {
            return;
        }
        BlockEntityUtil.sendUpdatePacket((BlockEntity)blockEntity2);
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)blockEntity2, (BlockPos)message.getPos());
    }

    public static void handleSendMailMessage(ServerPlayer player, C2SMessageSendMail message) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof PostBoxMenu)) {
            return;
        }
        PostBoxMenu postBox = (PostBoxMenu)abstractContainerMenu;
        if (postBox.getMail().m_41619_()) {
            return;
        }
        Mail mail = new Mail("Yo", postBox.getMail(), player.m_7755_().getString());
        if (!PostOffice.sendMailToPlayer(message.getPlayerId(), message.getMailBoxId(), mail)) {
            player.m_213846_((Component)Component.m_237115_((String)"message.cfm.mail_queue_full"));
            return;
        }
        postBox.removeMail();
    }

    public static void handleSetDoorMatMessage(ServerPlayer player, C2SMessageSetDoorMat message) {
        ServerLevel level = player.m_9236_();
        if (!level.m_46749_(message.getPos())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(message.getPos());
        if (!(blockEntity instanceof DoorMatBlockEntity)) {
            return;
        }
        DoorMatBlockEntity doorMat = (DoorMatBlockEntity)blockEntity;
        doorMat.setMessage(message.getMessage());
    }

    public static void handleSetMailBoxNameMessage(ServerPlayer player, C2SMessageSetMailBoxName message) {
        ServerLevel level = player.m_9236_();
        if (!level.m_46749_(message.getPos())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(message.getPos());
        if (!(blockEntity instanceof MailBoxBlockEntity)) {
            return;
        }
        MailBoxBlockEntity mailBox = (MailBoxBlockEntity)blockEntity;
        if (!player.m_20148_().equals(mailBox.getOwnerId())) {
            return;
        }
        if (!mailBox.m_6542_((Player)player)) {
            return;
        }
        if (!PostOffice.setMailBoxName(player.m_20148_(), mailBox.getId(), message.getName())) {
            return;
        }
        BlockEntityUtil.sendUpdatePacket((BlockEntity)mailBox);
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)mailBox, (BlockPos)message.getPos());
    }
}

