/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.model;

import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.SimpleUnbakedGeometry;

public class ElementsModelWrapped
extends SimpleUnbakedGeometry<ElementsModelWrapped> {
    private final List<BlockElement> elements;

    private ElementsModelWrapped(List<BlockElement> elements) {
        this.elements = elements;
    }

    public void addQuads(IGeometryBakingContext context, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation) {
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(rootTransform), modelState.m_7538_());
        }
        for (BlockElement element : this.elements) {
            for (Direction direction : element.f_111310_.keySet()) {
                BlockElementFace face = (BlockElementFace)element.f_111310_.get(direction);
                TextureAtlasSprite sprite = spriteGetter.apply(context.getMaterial(face.f_111356_));
                BakedQuad quad = BlockModel.m_111437_((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)modelState, (ResourceLocation)modelLocation);
                if (face.f_111354_ == null) {
                    modelBuilder.addUnculledFace(quad);
                    continue;
                }
                modelBuilder.addCulledFace(modelState.m_6189_().rotateTransform(face.f_111354_), quad);
            }
        }
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        if (context.hasMaterial("particle")) {
            textures.add(context.getMaterial("particle"));
        }
        for (BlockElement part : this.elements) {
            for (BlockElementFace face : part.f_111310_.values()) {
                Material texture = context.getMaterial(face.f_111356_);
                if (texture.m_119203_().equals((Object)MissingTextureAtlasSprite.m_118071_())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.f_111356_, (Object)context.getModelName()));
                }
                textures.add(texture);
            }
        }
        return textures;
    }

    public static final class Loader
    implements IGeometryLoader<ElementsModelWrapped> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public ElementsModelWrapped read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            if (!jsonObject.has("elements")) {
                throw new JsonParseException("An element model must have an \"elements\" member.");
            }
            ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)jsonObject, (String)"elements")) {
                elements.add((BlockElement)deserializationContext.deserialize(element, BlockElement.class));
            }
            return new ElementsModelWrapped(elements);
        }
    }
}

