/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.client.particle.options.BiColorParticleOptions;
import cofh.core.client.particle.options.ColorParticleOptions;
import cofh.core.init.CoreParticles;
import cofh.core.item.IEntityRayTraceItem;
import cofh.core.item.ITrackedItem;
import cofh.core.item.ItemCoFH;
import cofh.core.util.helpers.ArcheryHelper;
import cofh.core.util.helpers.vfx.Color;
import cofh.lib.util.Constants;
import java.util.Comparator;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DevStickItem
extends ItemCoFH
implements IEntityRayTraceItem,
ITrackedItem {
    public DevStickItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        Vec3 pos = context.m_43720_();
        BlockPos blockPos = context.m_8083_().m_121945_(context.m_43719_());
        Random rand = new Random();
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int durationRemaining) {
        int duration = this.m_8105_(stack) - durationRemaining;
        Random rand = new Random();
        if (level.f_46443_ && duration % 6 == 0) {
            Optional<EntityHitResult> closest;
            Vec3 look;
            Vec3 end;
            float spread = 0.01f;
            Vec3 start = living.m_146892_();
            BlockHitResult blockHit = level.m_45547_(new ClipContext(start, end = start.m_82549_((look = living.m_20154_()).m_82490_(16.0)).m_82520_((double)rand.nextFloat(-spread, spread), (double)rand.nextFloat(-spread, spread), (double)rand.nextFloat(-spread, spread)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
            if (blockHit.m_6662_() != HitResult.Type.MISS) {
                end = blockHit.m_82450_();
            }
            if ((closest = ArcheryHelper.findHitEntities(level, null, start, end, 0.0, EntitySelector.f_20403_.and(EntitySelector.f_20406_)).min(Comparator.comparingDouble(result -> result.m_82450_().m_82557_(start)))).isPresent()) {
                end = closest.get().m_82450_();
                if (living instanceof Player) {
                    Player player = (Player)living;
                    this.sendEntityRayTrace(player, closest.get().m_82443_(), start, end);
                }
            }
            level.m_7785_(start.f_82479_, start.f_82480_, start.f_82481_, SoundEvents.f_11687_, SoundSource.PLAYERS, 0.5f, 0.5f + spread * 0.2f + rand.nextFloat(0.1f), false);
            Vec3 pos = start.m_82549_(look.m_82537_(new Vec3(0.0, 0.3, 0.0))).m_82520_(0.0, -0.1, 0.0).m_82549_(look.m_82490_((double)0.35f));
            float time = (float)end.m_82546_(start).m_82553_() * 0.2f;
            int rgba = -1405431553;
            level.m_7106_((ParticleOptions)new BiColorParticleOptions((ParticleType<? extends BiColorParticleOptions>)((ParticleType)CoreParticles.SHARD.get()), 2.0f, time, 0.0f, rgba, 1948690943), pos.f_82479_, pos.f_82480_, pos.f_82481_, end.f_82479_, end.f_82480_, end.f_82481_);
            level.m_7106_((ParticleOptions)new ColorParticleOptions((ParticleType<? extends ColorParticleOptions>)((ParticleType)CoreParticles.BLAST.get()), 1.0f, 4 + rand.nextInt(2), time, Color.fromRGBA(rgba).scaleRGB(rand.nextFloat(0.85f, 1.15f)).toRGBA()), end.f_82479_, end.f_82480_, end.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int durationRemaining) {
        if (living instanceof Player) {
            Player player = (Player)living;
            player.m_36335_().m_41524_(stack.m_41720_(), 10);
        }
        if (level.f_46443_) {
            // empty if block
        }
    }

    @Override
    public void handleEntityRayTrace(Level level, ItemStack stack, Player player, Entity target, Vec3 origin, Vec3 hit) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            int invuln = living.f_19802_;
            living.m_21051_(Attributes.f_22278_).m_22118_(new AttributeModifier(Constants.UUID_WEAPON_KNOCKBACK, "b", 1.0, AttributeModifier.Operation.ADDITION));
            living.f_19802_ = 0;
            living.m_6469_(DamageSource.m_19344_((Player)player), 6.0f);
            living.f_19802_ = invuln;
            living.m_21051_(Attributes.f_22278_).m_22120_(Constants.UUID_WEAPON_KNOCKBACK);
        }
    }

    @Override
    public void onSwapFrom(Player player, InteractionHand hand, ItemStack stack, int duration) {
        Item item = stack.m_41720_();
        if (!player.m_36335_().m_41519_(item) && duration > 0) {
            player.m_36335_().m_41524_(item, 10);
        }
    }
}

