/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.goggles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.equipment.goggles.IProxyHoveringInformation;
import com.simibubi.create.content.trains.entity.TrainRelocator;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.gui.RemovedGuiUtils;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.outliner.Outline;
import com.simibubi.create.foundation.outliner.Outliner;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CClient;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class GoggleOverlayRenderer {
    public static final IGuiOverlay OVERLAY = GoggleOverlayRenderer::renderOverlay;
    private static final Map<Object, Outliner.OutlineEntry> outlines = CreateClient.OUTLINER.getOutlines();
    public static int hoverTicks = 0;
    public static BlockPos lastHovered = null;

    public static void renderOverlay(ForgeGui gui, PoseStack poseStack, float partialTicks, int width, int height) {
        Color colorBorderBot;
        boolean exceptionAdded;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        HitResult objectMouseOver = mc.f_91077_;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            lastHovered = null;
            hoverTicks = 0;
            return;
        }
        for (Outliner.OutlineEntry entry : outlines.values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
            return;
        }
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        ClientLevel world = mc.f_91073_;
        BlockPos pos = result.m_82425_();
        int prevHoverTicks = hoverTicks++;
        lastHovered = pos;
        pos = GoggleOverlayRenderer.proxiedOverlayPosition((Level)world, pos);
        BlockEntity be = world.m_7702_(pos);
        boolean wearingGoggles = GogglesItem.isWearingGoggles((Player)mc.f_91074_);
        boolean hasGoggleInformation = be instanceof IHaveGoggleInformation;
        boolean hasHoveringInformation = be instanceof IHaveHoveringInformation;
        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation)be;
            goggleAddedInformation = gte.addToGoggleTooltip(tooltip, mc.f_91074_.m_6144_());
        }
        if (hasHoveringInformation) {
            if (!tooltip.isEmpty()) {
                tooltip.add(Components.immutableEmpty());
            }
            IHaveHoveringInformation hte = (IHaveHoveringInformation)be;
            hoverAddedInformation = hte.addToTooltip(tooltip, mc.f_91074_.m_6144_());
            if (goggleAddedInformation && !hoverAddedInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (be instanceof IDisplayAssemblyExceptions && (exceptionAdded = ((IDisplayAssemblyExceptions)be).addExceptionToTooltip(tooltip))) {
            hasHoveringInformation = true;
            hoverAddedInformation = true;
        }
        if (!hasHoveringInformation) {
            hasHoveringInformation = hoverAddedInformation = TrainRelocator.addToTooltip(tooltip, mc.f_91074_.m_6144_());
            if (hoverAddedInformation) {
                hoverTicks = prevHoverTicks + 1;
            }
        }
        if (hasGoggleInformation && !goggleAddedInformation && hasHoveringInformation && !hoverAddedInformation) {
            hoverTicks = 0;
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (wearingGoggles && AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
            int n;
            Direction[] directions = Iterate.directionsInAxis(((Direction)state.m_61143_((Property)PistonExtensionPoleBlock.f_52588_)).m_122434_());
            int poles = 1;
            boolean bl = false;
            for (Direction dir : directions) {
                int attachedPoles = PistonExtensionPoleBlock.PlacementHelper.get().attachedPoles((Level)world, pos, dir);
                poles += attachedPoles;
                n |= world.m_8055_(pos.m_5484_(dir, attachedPoles + 1)).m_60734_() instanceof MechanicalPistonBlock;
            }
            if (n == 0) {
                hoverTicks = 0;
                return;
            }
            if (!tooltip.isEmpty()) {
                tooltip.add(Components.immutableEmpty());
            }
            tooltip.add((Component)IHaveGoggleInformation.componentSpacing.m_6879_().m_7220_((Component)Lang.translateDirect("gui.goggles.pole_length", new Object[0])).m_7220_((Component)Components.literal(" " + poles)));
        }
        if (tooltip.isEmpty()) {
            hoverTicks = 0;
            return;
        }
        poseStack.m_85836_();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.f_91062_.m_92852_(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        CClient cClient = AllConfigs.client();
        int posX = width / 2 + (Integer)cClient.overlayOffsetX.get();
        int posY = height / 2 + (Integer)cClient.overlayOffsetY.get();
        posX = Math.min(posX, width - tooltipTextWidth - 20);
        posY = Math.min(posY, height - tooltipHeight - 20);
        float fade = Mth.m_14036_((float)(((float)hoverTicks + partialTicks) / 24.0f), (float)0.0f, (float)1.0f);
        Boolean useCustom = (Boolean)cClient.overlayCustomColor.get();
        Color colorBackground = useCustom != false ? new Color((Integer)cClient.overlayBackgroundColor.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BACKGROUND).scaleAlpha(0.75f);
        Color colorBorderTop = useCustom != false ? new Color((Integer)cClient.overlayBorderColorTop.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BORDER, true).copy();
        Color color = colorBorderBot = useCustom != false ? new Color((Integer)cClient.overlayBorderColorBot.get()) : Theme.c(Theme.Key.VANILLA_TOOLTIP_BORDER, false).copy();
        if (fade < 1.0f) {
            poseStack.m_85837_(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cClient.overlayOffsetX.get()).intValue() + 0.5f) * 8.0, 0.0, 0.0);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        RemovedGuiUtils.drawHoveringText(poseStack, tooltip, posX, posY, width, height, -1, colorBackground.getRGB(), colorBorderTop.getRGB(), colorBorderBot.getRGB(), mc.f_91062_);
        ItemStack item = AllItems.GOGGLES.asStack();
        ((RenderElement)GuiGameElement.of(item).at(posX + 10, posY - 16, 450.0f)).render(poseStack);
        poseStack.m_85849_();
    }

    public static BlockPos proxiedOverlayPosition(Level level, BlockPos pos) {
        BlockState targetedState = level.m_8055_(pos);
        Block block = targetedState.m_60734_();
        if (block instanceof IProxyHoveringInformation) {
            IProxyHoveringInformation proxy = (IProxyHoveringInformation)block;
            return proxy.getInformationSource(level, pos, targetedState);
        }
        return pos;
    }
}

