/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.utils;

import java.util.Arrays;
import java.util.Calendar;
import java.util.function.BooleanSupplier;

public enum Events {
    CHRISTMAS(() -> Events.matchMonth(11) && Events.matchDays(20, 31)),
    HALLOWEEN(() -> Events.matchMonth(9) && Events.matchDays(25, 31)),
    ST_PATRICKS_DAY(() -> Events.matchMonth(2) && Events.matchDays(15, 19)),
    NONE(() -> false);

    private final BooleanSupplier checker;

    private Events(BooleanSupplier checker) {
        this.checker = checker;
    }

    private boolean isDay() {
        return this.checker.getAsBoolean();
    }

    public static Events getCurrentEvent() {
        return Arrays.stream(Events.values()).filter(Events::isDay).findFirst().orElse(NONE);
    }

    private static boolean matchMonth(int month) {
        return Calendar.getInstance().get(2) == month;
    }

    private static boolean matchDays(int start, int end) {
        int day = Calendar.getInstance().get(5);
        return day >= start && day <= end;
    }
}

