/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.utils;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import tfar.dankstorage.DankStorage;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.item.DankItem;
import tfar.dankstorage.mixin.CraftingContainerAccess;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.utils.DankStats;
import tfar.dankstorage.utils.ItemStackWrapper;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.world.ClientData;
import tfar.dankstorage.world.DankInventory;

public class Utils {
    public static final String ID = "dankstorage:id";
    public static final Set<ResourceLocation> taglist = new HashSet<ResourceLocation>();
    public static boolean DEV = false;
    public static final int INVALID = -1;
    public static final String SET = "settings";
    public static final String SELECTED = "selectedSlot";
    public static final String CON = "construction";
    private static List<CraftingRecipe> REVERSIBLE3x3 = new ArrayList<CraftingRecipe>();
    private static List<CraftingRecipe> REVERSIBLE2x2 = new ArrayList<CraftingRecipe>();
    private static boolean cached = false;
    private static final CraftingContainer DUMMY = new CraftingContainer(null, 1, 1){

        public void m_6836_(int i, ItemStack itemStack) {
            ((CraftingContainerAccess)((Object)this)).getItems().set(i, (Object)itemStack);
        }

        public ItemStack m_7407_(int i, int j) {
            return ContainerHelper.m_18969_(((CraftingContainerAccess)((Object)this)).getItems(), (int)i, (int)j);
        }
    };
    public static final UseType[] useTypes = UseType.values();

    private static TagKey<Item> bind(ResourceLocation string) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)string);
    }

    @Nullable
    public static CompoundTag getSettings(ItemStack bag) {
        return Utils.hasSettings(bag) ? bag.m_41783_().m_128469_(SET) : null;
    }

    public static CompoundTag getOrCreateSettings(ItemStack bag) {
        if (Utils.hasSettings(bag)) {
            return bag.m_41783_().m_128469_(SET);
        }
        bag.m_41784_().m_128365_(SET, (Tag)new CompoundTag());
        return Utils.getSettings(bag);
    }

    public static PickupMode getPickupMode(ItemStack bag) {
        CompoundTag tag = Utils.getSettings(bag);
        if (tag != null) {
            return PickupMode.PICKUP_MODES[tag.m_128451_("mode")];
        }
        return PickupMode.none;
    }

    public static void setPickupMode(ItemStack bag, PickupMode mode) {
        CompoundTag tag = Utils.getOrCreateSettings(bag);
        tag.m_128405_("mode", mode.ordinal());
    }

    public static boolean isConstruction(ItemStack bag) {
        CompoundTag settings = Utils.getSettings(bag);
        return settings != null && settings.m_128451_(CON) == UseType.construction.ordinal();
    }

    public static DankStats getStatsfromRows(int rows) {
        switch (rows) {
            case 1: {
                return DankStats.one;
            }
            case 2: {
                return DankStats.two;
            }
            case 3: {
                return DankStats.three;
            }
            case 4: {
                return DankStats.four;
            }
            case 5: {
                return DankStats.five;
            }
            case 6: {
                return DankStats.six;
            }
            case 9: {
                return DankStats.seven;
            }
        }
        throw new IllegalStateException(String.valueOf(rows));
    }

    public static void cyclePickupMode(ItemStack bag, Player player) {
        int ordinal = Utils.getOrCreateSettings(bag).m_128451_("mode");
        if (++ordinal > PickupMode.PICKUP_MODES.length - 1) {
            ordinal = 0;
        }
        Utils.getOrCreateSettings(bag).m_128405_("mode", ordinal);
        player.m_5661_((Component)Utils.translatable("dankstorage.mode." + PickupMode.PICKUP_MODES[ordinal].name()), true);
    }

    public static UseType getUseType(ItemStack bag) {
        CompoundTag settings = Utils.getSettings(bag);
        return settings != null ? useTypes[settings.m_128451_(CON)] : UseType.bag;
    }

    private static void cyclePlacement(ItemStack bag, Player player) {
        CompoundTag tag = Utils.getOrCreateSettings(bag);
        int ordinal = tag.m_128451_(CON);
        if (++ordinal >= useTypes.length) {
            ordinal = 0;
        }
        tag.m_128405_(CON, ordinal);
        player.m_5661_((Component)Utils.translatable("dankstorage.usetype." + useTypes[ordinal].name()), true);
    }

    public static int getSelectedSlot(ItemStack bag) {
        CompoundTag settings = Utils.getSettings(bag);
        return settings != null && settings.m_128441_(SELECTED) ? settings.m_128451_(SELECTED) : -1;
    }

    public static void setSelectedSlot(ItemStack bag, int slot) {
        Utils.getOrCreateSettings(bag).m_128405_(SELECTED, slot);
    }

    public static void setPickSlot(Level level, ItemStack bag, ItemStack stack) {
        int slot;
        DankInventory dankInventory = Utils.getInventory(bag, level);
        if (dankInventory != null && (slot = Utils.findSlotMatchingItem(dankInventory, stack)) != -1) {
            Utils.setSelectedSlot(bag, slot);
        }
    }

    public static int findSlotMatchingItem(DankInventory dankInventory, ItemStack itemStack) {
        for (int i = 0; i < dankInventory.getSlots(); ++i) {
            ItemStack stack = dankInventory.getStackInSlot(i);
            if (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getSelectedItem(ItemStack bag, Level level) {
        if (bag.m_41782_()) {
            int selected = Utils.getSelectedSlot(bag);
            if (selected == -1) {
                return ItemStack.f_41583_;
            }
            if (!level.f_46443_) {
                DankInventory dankInventory = Utils.getInventory(bag, level);
                if (dankInventory != null) {
                    return dankInventory.getStackInSlot(selected);
                }
            } else {
                return ClientData.selectedItem;
            }
        }
        return ItemStack.f_41583_;
    }

    public static void merge(List<ItemStack> stacks, ItemStack toMerge) {
        for (ItemStack stack : stacks) {
            int grow;
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)toMerge) || (grow = Math.min(Integer.MAX_VALUE - stack.m_41613_(), toMerge.m_41613_())) <= 0) continue;
            stack.m_41769_(grow);
            toMerge.m_41774_(grow);
        }
        if (!toMerge.m_41619_()) {
            stacks.add(toMerge);
        }
    }

    public static List<ItemStackWrapper> wrap(List<ItemStack> stacks) {
        return stacks.stream().map(ItemStackWrapper::new).collect(Collectors.toList());
    }

    public static DankStats getStats(ItemStack bag) {
        return ((DankItem)bag.m_41720_()).stats;
    }

    public static void changeSelectedSlot(ItemStack bag, boolean right, ServerPlayer player) {
        DankInventory handler = Utils.getInventory(bag, (Level)player.m_9236_());
        if (handler == null || handler.noValidSlots()) {
            return;
        }
        int selectedSlot = Utils.getSelectedSlot(bag);
        int size = handler.getSlots();
        if (right) {
            if (++selectedSlot >= size) {
                selectedSlot = 0;
            }
        } else if (--selectedSlot < 0) {
            selectedSlot = size - 1;
        }
        ItemStack selected = handler.getStackInSlot(selectedSlot);
        while (selected.m_41619_() || selected.m_204117_(ModTags.BLACKLISTED_USAGE)) {
            if (right) {
                if (++selectedSlot >= size) {
                    selectedSlot = 0;
                }
            } else if (--selectedSlot < 0) {
                selectedSlot = size - 1;
            }
            selected = handler.getStackInSlot(selectedSlot);
        }
        if (selectedSlot != -1) {
            Utils.setSelectedSlot(bag, selectedSlot);
            DankPacketHandler.sendSelectedItem(player, selected);
            player.m_5661_(selected.m_41786_(), true);
        }
    }

    public static int getFrequency(ItemStack bag) {
        CompoundTag settings = Utils.getSettings(bag);
        if (settings != null && settings.m_128441_(ID)) {
            return settings.m_128451_(ID);
        }
        return -1;
    }

    public static void setFrequency(ItemStack bag, int frequency) {
        Utils.getOrCreateSettings(bag).m_128405_(ID, frequency);
    }

    private static boolean hasSettings(ItemStack bag) {
        return bag.m_41782_() && bag.m_41783_().m_128441_(SET);
    }

    public static boolean oredict(ItemStack bag) {
        return bag.m_41720_() instanceof DankItem && bag.m_41782_() && Utils.getSettings(bag).m_128471_("tag");
    }

    public static DankInventory getOrCreateInventory(ItemStack bag, Level level) {
        if (!level.f_46443_) {
            int id = Utils.getFrequency(bag);
            return DankStorage.instance.data.getOrCreateInventory(id, Utils.getStats(bag));
        }
        throw new RuntimeException("Attempted to get inventory on client");
    }

    public static DankInventory getInventory(ItemStack bag, Level level) {
        if (!level.f_46443_) {
            int id = Utils.getFrequency(bag);
            return DankStorage.instance.data.getInventory(id);
        }
        throw new RuntimeException("Attempted to get inventory on client");
    }

    public static int getNbtSize(ItemStack stack) {
        return Utils.getNbtSize(stack.m_41783_());
    }

    public static DankItem getItemFromTier(int tier) {
        return (DankItem)((Object)Registry.f_122827_.m_7745_(new ResourceLocation("dankstorage", "dank_" + tier)));
    }

    public static int getNbtSize(@Nullable CompoundTag nbt) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.m_130079_(nbt);
        buffer.release();
        return buffer.writerIndex();
    }

    public static ItemStack getItemStackInSelectedSlot(ItemStack bag, ServerLevel level) {
        DankInventory inv = Utils.getInventory(bag, (Level)level);
        if (inv == null) {
            return ItemStack.f_41583_;
        }
        int slot = Utils.getSelectedSlot(bag);
        if (slot == -1) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = inv.getStackInSlot(slot);
        return stack.m_204117_(ModTags.BLACKLISTED_USAGE) ? ItemStack.f_41583_ : stack;
    }

    public static boolean isHoldingDank(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof DankItem) {
            return true;
        }
        stack = player.m_21206_();
        return stack.m_41720_() instanceof DankItem;
    }

    public static boolean canMerge(ItemStack first, ItemStack second, Container inventory) {
        if (first.m_41720_() != second.m_41720_()) {
            return false;
        }
        if (first.m_41773_() != second.m_41773_()) {
            return false;
        }
        if (first.m_41613_() > inventory.m_6893_()) {
            return false;
        }
        return ItemStack.m_41658_((ItemStack)first, (ItemStack)second);
    }

    public static void warn(Player player, DankStats item, DankStats inventory) {
        player.m_213846_((Component)Utils.literal("Dank Item Level " + item.ordinal() + " cannot open Dank Inventory Level " + inventory.ordinal()));
    }

    @Nullable
    private static InteractionHand getHandWithDank(Player player) {
        if (player.m_21205_().m_41720_() instanceof DankItem) {
            return InteractionHand.MAIN_HAND;
        }
        if (player.m_21206_().m_41720_() instanceof DankItem) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    public static ItemStack getDank(Player player) {
        InteractionHand hand = Utils.getHandWithDank(player);
        return hand == null ? ItemStack.f_41583_ : player.m_21120_(hand);
    }

    public static void uncacheRecipes(RecipeManager manager) {
        cached = false;
    }

    public static Pair<ItemStack, Integer> compress(ItemStack stack) {
        for (CraftingRecipe recipe : REVERSIBLE3x3) {
            if (!((Ingredient)recipe.m_7527_().get(0)).test(stack)) continue;
            return Pair.of((Object)recipe.m_8043_(), (Object)9);
        }
        for (CraftingRecipe recipe : REVERSIBLE2x2) {
            if (!((Ingredient)recipe.m_7527_().get(0)).test(stack)) continue;
            return Pair.of((Object)recipe.m_8043_(), (Object)4);
        }
        return Pair.of((Object)ItemStack.f_41583_, (Object)0);
    }

    public static boolean canCompress(ServerLevel level, ItemStack stack) {
        if (!cached) {
            REVERSIBLE3x3 = Utils.findReversibles(level, 3);
            REVERSIBLE2x2 = Utils.findReversibles(level, 2);
            cached = true;
        }
        for (CraftingRecipe recipe : REVERSIBLE3x3) {
            if (!((Ingredient)recipe.m_7527_().get(0)).test(stack)) continue;
            return stack.m_41613_() >= 9;
        }
        for (CraftingRecipe recipe : REVERSIBLE2x2) {
            if (!((Ingredient)recipe.m_7527_().get(0)).test(stack)) continue;
            return stack.m_41613_() >= 4;
        }
        return false;
    }

    public static List<CraftingRecipe> findReversibles(ServerLevel level, int size) {
        ArrayList<CraftingRecipe> compactingRecipes = new ArrayList<CraftingRecipe>();
        List recipes = level.m_7465_().m_44013_(RecipeType.f_44107_);
        for (CraftingRecipe recipe : recipes) {
            NonNullList inputs;
            Ingredient first;
            if (!(recipe instanceof ShapedRecipe)) continue;
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            int x = shapedRecipe.m_44220_();
            int y = shapedRecipe.m_44221_();
            if (x != size || x != y || (first = (Ingredient)(inputs = shapedRecipe.m_7527_()).get(0)) == Ingredient.f_43901_) continue;
            boolean same = true;
            for (int i = 1; i < x * y; ++i) {
                Ingredient next = (Ingredient)inputs.get(i);
                if (next == first) continue;
                same = false;
                break;
            }
            if (!same || shapedRecipe.m_8043_().m_41613_() != 1) continue;
            DUMMY.m_6836_(0, shapedRecipe.m_8043_());
            level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)DUMMY, (Level)level).ifPresent(reverseRecipe -> {
                if (reverseRecipe.m_8043_().m_41613_() == size * size) {
                    compactingRecipes.add((CraftingRecipe)shapedRecipe);
                }
            });
        }
        return compactingRecipes;
    }

    public static MutableComponent translatable(String s) {
        return Component.m_237115_((String)s);
    }

    public static MutableComponent translatable(String string, Object ... objects) {
        return Component.m_237110_((String)string, (Object[])objects);
    }

    public static MutableComponent literal(String s) {
        return Component.m_237113_((String)s);
    }

    public static void toggleTagMode(ServerPlayer player) {
        ItemStack dank = Utils.getDank((Player)player);
        if (!dank.m_41619_()) {
            boolean toggle = Utils.oredict(dank);
            player.m_21205_().m_41784_().m_128379_("tag", !toggle);
        }
    }

    public static void togglePickupMode(ServerPlayer player) {
        ItemStack bag = Utils.getDank((Player)player);
        if (!bag.m_41619_()) {
            Utils.cyclePickupMode(bag, (Player)player);
        }
    }

    public static void toggleUseType(ServerPlayer player) {
        ItemStack dank = Utils.getDank((Player)player);
        if (!dank.m_41619_()) {
            Utils.cyclePlacement(dank, (Player)player);
        }
    }

    public static enum UseType {
        bag,
        construction;

    }
}

