/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModLoader;
import org.apache.logging.log4j.util.Supplier;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.imc.DataManagerIMC;
import sirttas.dpanvil.data.manager.AbstractDataManager;
import sirttas.dpanvil.data.serializer.CodecJsonDataSerializer;
import sirttas.dpanvil.data.serializer.IJsonDataSerializer;

public class DataManagerWrapper
implements PreparableReloadListener {
    private final Map<ResourceKey<IDataManager<?>>, IDataManager<?>> managers = Maps.newHashMap();
    private final Map<ResourceKey<IDataManager<?>>, IJsonDataSerializer<?>> serializers = Maps.newHashMap();

    public static <T> void logManagerException(ResourceKey<? super IDataManager<T>> key, Throwable e) {
        if (e != null) {
            DataPackAnvilApi.LOGGER.error(() -> "Exception while loading data for manager " + key + ":", e);
        }
    }

    public <T, M extends IDataManager<T>> M getManager(ResourceKey<? super IDataManager<T>> key) {
        return (M)this.managers.get(key);
    }

    public <T, M extends IDataManager<T>> M getManager(Class<T> clazz) {
        return (M)((IDataManager)this.managers.values().stream().filter(manager -> manager.getContentType().isAssignableFrom(clazz)).findAny().orElse(null));
    }

    public <T> ResourceKey<IDataManager<T>> getKey(IDataManager<T> manager) {
        return this.managers.entrySet().stream().filter(e -> ((IDataManager)e.getValue()).equals(manager)).map(e -> (ResourceKey)this.cast(e.getKey())).findAny().orElseGet(() -> IDataManager.createManagerKey(DataPackAnvilApi.ID_NONE));
    }

    private <T> T cast(Object key) {
        return (T)key;
    }

    public <T, S extends IJsonDataSerializer<T>> S getSerializer(ResourceKey<? super IDataManager<T>> key) {
        return (S)this.serializers.get(key);
    }

    public <T> void putManagerFromIMC(java.util.function.Supplier<?> supplier) {
        DataManagerIMC message = (DataManagerIMC)supplier.get();
        ResourceKey key = message.getKey();
        ResourceKey castedKey = (ResourceKey)this.cast(key);
        IDataManager manager = message.getManager();
        this.serializers.put(castedKey, this.buildSerializer(message));
        this.managers.put(castedKey, manager);
        if (manager instanceof AbstractDataManager) {
            ((AbstractDataManager)manager).setKey(key);
        }
    }

    private <T> IJsonDataSerializer<T> buildSerializer(final DataManagerIMC<T> message) {
        Codec<T> codec = message.getCodec();
        return codec != null ? new CodecJsonDataSerializer<T>(codec) : new IJsonDataSerializer<T>(){

            @Override
            public T read(JsonElement json) {
                Function<JsonElement, JsonElement> readJson = message.getReadJson();
                if (readJson != null) {
                    return readJson.apply(json);
                }
                throw new IllegalStateException("trying to read json without the proper serialization tools for manager : " + message.getKey() + " makes sure you provide a correct json serializer to it.");
            }

            @Override
            public T read(FriendlyByteBuf buf) {
                return message.getReadPacket().apply(buf);
            }

            @Override
            public void write(T data, FriendlyByteBuf buf) {
                message.getWritePacket().accept(buf, (FriendlyByteBuf)data);
            }
        };
    }

    public Collection<ResourceKey<IDataManager<?>>> ids() {
        return this.managers.keySet();
    }

    public Map<ResourceKey<IDataManager<?>>, IDataManager<?>> getDataManagers() {
        return this.managers;
    }

    @NotNull
    public CompletableFuture<Void> m_5540_(@NotNull PreparableReloadListener.PreparationBarrier stage, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller preparationsProfiler, @NotNull ProfilerFiller reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        if (ModLoader.isLoadingStateValid() && !this.managers.isEmpty()) {
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf((CompletableFuture[])this.managers.entrySet().stream().map(entry -> {
                IDataManager manager = (IDataManager)entry.getValue();
                return manager.m_5540_(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor).handle(this.handleManagerException((ResourceKey)entry.getKey()));
            }).toArray(CompletableFuture[]::new));
            return completableFuture.thenRun(this::postLoad);
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private void postLoad() {
        DataPackAnvilApi.LOGGER.debug("DataManagers loading compleat: {}", new Supplier[]{() -> {
            StringBuilder logBuilder = new StringBuilder();
            this.managers.forEach((managerId, manager) -> {
                logBuilder.append("\r\n").append(managerId).append(" ").append(manager.getData().size()).append(" entries:\r\n");
                manager.getData().forEach((id, data) -> logBuilder.append("\t").append(id).append(": ").append(data).append("\r\n"));
            });
            return logBuilder.toString();
        }});
    }

    private BiFunction<Void, Throwable, Void> handleManagerException(ResourceKey<IDataManager<?>> key) {
        return (r, e) -> {
            DataManagerWrapper.logManagerException(key, e);
            return r;
        };
    }
}

