/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.diffuser;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.diffuser.DiffuserBlockEntity;
import sirttas.elementalcraft.renderer.ECRendererHelper;

@OnlyIn(value=Dist.CLIENT)
public class DiffuserRenderer
implements BlockEntityRenderer<DiffuserBlockEntity> {
    public static final ResourceLocation CUBE_LOCATION = ElementalCraft.createRL("block/diffuser_cube");
    private static final Quaternion ROTATION = Vector3f.f_122223_.m_122240_(45.0f);
    private BakedModel cubeModel;

    public void render(@Nonnull DiffuserBlockEntity te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        float angle = ECRendererHelper.getClientTicks(partialTicks);
        if (this.cubeModel == null) {
            this.cubeModel = Minecraft.m_91087_().m_91304_().getModel(CUBE_LOCATION);
        }
        ECRendererHelper.renderRunes(matrixStack, buffer, te.getRuneHandler(), angle, light, overlay);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.1, 0.5);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        matrixStack.m_85845_(ROTATION);
        matrixStack.m_85837_(-0.1875, -0.1875, -0.1875);
        ECRendererHelper.renderModel(this.cubeModel, matrixStack, buffer, te, light, overlay);
        matrixStack.m_85849_();
    }

    static {
        ROTATION.m_80148_(Vector3f.f_122227_.m_122240_(45.0f));
    }
}

