/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.extractor;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.container.IContainerTopBlockEntity;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.config.ECConfig;

public class ExtractorBlockEntity
extends AbstractECBlockEntity
implements IContainerTopBlockEntity {
    private int extractionAmount;
    private final RuneHandler runeHandler;
    private ISingleElementStorage containerCache;

    public ExtractorBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.EXTRACTOR, pos, state);
        if (state.m_60713_((Block)ECBlocks.EXTRACTOR_IMPROVED.get())) {
            this.extractionAmount = (Integer)ECConfig.COMMON.improvedExtractorExtractionAmount.get();
            this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.improvedExtractorMaxRunes.get(), this::m_6596_);
        } else {
            this.extractionAmount = (Integer)ECConfig.COMMON.extractorExtractionAmount.get();
            this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.extractorMaxRunes.get(), this::m_6596_);
        }
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.extractionAmount = compound.m_128451_("extraction_amount");
        if (compound.m_128441_("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.m_128437_("rune_handler", 8));
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("extraction_amount", this.extractionAmount);
        compound.m_128365_("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    protected Optional<BlockState> getSourceState() {
        return this.f_58857_ != null ? Optional.of(this.f_58857_.m_8055_(this.f_58858_.m_7494_())) : Optional.empty();
    }

    public ElementType getSourceElementType() {
        return this.getSourceState().filter(s -> s.m_60734_() == ECBlocks.SOURCE.get()).map(ElementType::getElementType).orElse(ElementType.NONE);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ExtractorBlockEntity extractor) {
        if (extractor.canExtract()) {
            BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos.m_7494_(), SourceBlockEntity.class).map(SourceBlockEntity::getElementStorage).ifPresent(sourceStorage -> extractor.runeHandler.handleElementTransfer((ISingleElementStorage)sourceStorage, extractor.getContainer(), extractor.extractionAmount));
        }
    }

    public boolean canExtract() {
        if (this.f_58857_ == null) {
            return false;
        }
        return BlockEntityHelper.getBlockEntityAs((BlockGetter)this.f_58857_, this.f_58858_.m_7494_(), SourceBlockEntity.class).map(source -> {
            if (source.isExhausted()) {
                return false;
            }
            ElementType sourceElementType = source.getElementType();
            ISingleElementStorage container = this.getContainer();
            return this.m_58898_() && sourceElementType != ElementType.NONE && container != null && (container.getElementAmount() < container.getElementCapacity() || container.getElementType() != sourceElementType);
        }).orElse(false);
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Override
    public ISingleElementStorage getContainer() {
        if (this.containerCache == null) {
            this.containerCache = IContainerTopBlockEntity.super.getContainer();
        }
        return this.containerCache;
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ElementalCraftCapabilities.RUNE_HANDLE) {
            return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
        }
        return super.getCapability(cap, side);
    }
}

