/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.crystallizer;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import sirttas.elementalcraft.block.instrument.InstrumentContainer;
import sirttas.elementalcraft.block.instrument.crystallizer.CrystallizerBlockEntity;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;

public class CrystallizerContainer
extends InstrumentContainer {
    private static final List<Ingredient> FIRST_SLOT_ITEMS = new ArrayList<Ingredient>();
    private static final List<Ingredient> SECOND_SLOT_ITEMS = new ArrayList<Ingredient>();
    private final CrystallizerBlockEntity crystallizer;

    public CrystallizerContainer(CrystallizerBlockEntity crystallizer) {
        super(crystallizer::m_6596_, 12);
        this.crystallizer = crystallizer;
    }

    public boolean m_7013_(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            return FIRST_SLOT_ITEMS.isEmpty() || FIRST_SLOT_ITEMS.stream().anyMatch(i -> i.test(stack));
        }
        if (slot == 1) {
            return SECOND_SLOT_ITEMS.isEmpty() || SECOND_SLOT_ITEMS.stream().anyMatch(i -> i.test(stack));
        }
        return this.crystallizer.isValidShard(stack);
    }

    public static void reload(RecipeManager recipeManager) {
        List recipes = recipeManager.m_44013_((RecipeType)ECRecipeTypes.CRYSTALLIZATION.get());
        FIRST_SLOT_ITEMS.clear();
        SECOND_SLOT_ITEMS.clear();
        for (CrystallizationRecipe recipe : recipes) {
            NonNullList<Ingredient> ingredients = recipe.m_7527_();
            if (!ingredients.isEmpty()) {
                FIRST_SLOT_ITEMS.add((Ingredient)ingredients.get(0));
            }
            if (ingredients.size() <= 1) continue;
            SECOND_SLOT_ITEMS.add((Ingredient)ingredients.get(1));
        }
    }
}

