/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.ElementPipeShapes;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.pipe.IPipeInteractingItem;
import sirttas.elementalcraft.tag.ECTags;

public class ElementPipeBlock
extends AbstractECEntityBlock {
    public static final String NAME = "elementpipe";
    public static final String NAME_IMPAIRED = "elementpipe_impaired";
    public static final String NAME_IMPROVED = "elementpipe_improved";
    public static final String NAME_CREATIVE = "elementpipe_creative";
    public static final EnumProperty<CoverType> COVER = EnumProperty.m_61587_((String)"cover", CoverType.class);
    private final PipeType type;

    public ElementPipeBlock(PipeType type) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60999_().m_60955_().m_60977_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(COVER, (Comparable)((Object)CoverType.NONE)));
        this.type = type;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> container) {
        container.m_61104_(new Property[]{COVER});
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ElementPipeBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return ElementPipeBlock.createECTicker(level, type, ECBlockEntityTypes.PIPE, level.f_46443_ ? ElementPipeBlockEntity::commonTick : ElementPipeBlockEntity::serverTick);
    }

    @Deprecated
    public void m_6807_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ElementPipeBlockEntity) {
            ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)blockEntity;
            pipe.refresh();
        }
    }

    @Deprecated
    public void m_213897_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ElementPipeBlockEntity) {
            ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)blockEntity;
            pipe.refresh();
        }
    }

    public static boolean showCover(BlockState state, Player player) {
        return ElementPipeBlock.isCovered(state) && (player == null || EntityHelper.handStream(player).noneMatch(stack -> !stack.m_41619_() && stack.m_204117_(ECTags.Items.PIPE_COVER_HIDING)));
    }

    private static boolean isCovered(BlockState state) {
        return state.m_61143_(COVER) == CoverType.COVERED;
    }

    private VoxelShape getCurrentShape(BlockState state, ElementPipeBlockEntity entity, Player player) {
        if (ElementPipeBlock.showCover(state, (Player)(entity != null ? player : null))) {
            return Shapes.m_83144_();
        }
        if (entity == null) {
            return Shapes.m_83040_();
        }
        return entity.getShape();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Player player = this.getPlayer(context);
        ElementPipeBlockEntity blockEntity = ElementPipeBlock.getBlockEntity(blockGetter, pos);
        if (blockGetter instanceof Level) {
            Level level = (Level)blockGetter;
            if (level.f_46443_) {
                voxelShape = (VoxelShape)this.getShapeAndFace(state, pos, blockEntity, Minecraft.m_91087_().f_91077_, player).getFirst();
                return voxelShape;
            }
        }
        voxelShape = this.getCurrentShape(state, blockEntity, player);
        return voxelShape;
    }

    private Player getPlayer(CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).m_193113_()) instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    public Pair<VoxelShape, Direction> getShapeAndFace(BlockState state, BlockPos pos, ElementPipeBlockEntity pipe, HitResult result, Player player) {
        BlockHitResult blockHitResult;
        if (!ElementPipeBlock.showCover(state, player) && result instanceof BlockHitResult && (blockHitResult = (BlockHitResult)result).m_6662_() == HitResult.Type.BLOCK && blockHitResult.m_82425_().equals((Object)pos)) {
            Vec3 hit = blockHitResult.m_82450_();
            for (Direction face : Direction.values()) {
                VoxelShape shape = pipe.getShape(face);
                if (!ShapeHelper.vectorCollideWithShape(shape, pos, hit)) continue;
                return Pair.of((Object)shape, (Object)face);
            }
            if (ShapeHelper.vectorCollideWithShape(ElementPipeShapes.BASE_SHAPE, pos, hit)) {
                return Pair.of((Object)ElementPipeShapes.BASE_SHAPE, (Object)blockHitResult.m_82434_());
            }
            if (ShapeHelper.vectorCollideWithShape(ElementPipeShapes.FRAME_SHAPE, pos, hit)) {
                return Pair.of((Object)ElementPipeShapes.FRAME_SHAPE, null);
            }
        }
        return Pair.of((Object)this.getCurrentShape(state, pipe, player), null);
    }

    @Deprecated
    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getCurrentShape(state, ElementPipeBlock.getBlockEntity(world, pos), null);
    }

    @Deprecated
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)level.m_7702_(pos);
        if (pipe != null) {
            Pair<VoxelShape, Direction> pair = this.getShapeAndFace(state, pos, ElementPipeBlock.getBlockEntity((BlockGetter)level, pos), (HitResult)hit, player);
            VoxelShape shape = (VoxelShape)pair.getFirst();
            if (shape == ElementPipeShapes.FRAME_SHAPE || state.m_61143_(COVER) == CoverType.FRAME) {
                return pipe.setCover(player, hand);
            }
            Direction face = (Direction)pair.getSecond();
            InteractionResult value = this.onShapeActivated(face, pipe, player, hand, hit);
            if (!value.m_19077_()) {
                player.m_5661_(pipe.getConnectionMessage(face), true);
                level.m_46672_(pos, (Block)this);
            }
            return value;
        }
        return InteractionResult.PASS;
    }

    private InteractionResult onShapeActivated(Direction face, ElementPipeBlockEntity pipe, Player player, InteractionHand hand, BlockHitResult hit) {
        if (face != null) {
            Item item;
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof IPipeInteractingItem) {
                IPipeInteractingItem item2 = (IPipeInteractingItem)item;
                return item2.useOnPipe(pipe, new UseOnContext(player, hand, new BlockHitResult(hit.m_82450_(), face, hit.m_82425_(), hit.m_82436_())));
            }
            return pipe.activatePipe(player, face);
        }
        return InteractionResult.PASS;
    }

    @Override
    @Deprecated
    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity te = level.m_7702_(pos);
            if (te instanceof ElementPipeBlockEntity) {
                ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)te;
                if (ElementPipeBlock.isCovered(state)) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)pipe.getCoverState().m_60734_()));
                }
                pipe.removeAllUpgrades();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    private static ElementPipeBlockEntity getBlockEntity(BlockGetter world, BlockPos pos) {
        return BlockEntityHelper.getBlockEntityAs(world, pos, ElementPipeBlockEntity.class).orElse(null);
    }

    public PipeType getType() {
        return this.type;
    }

    public static enum CoverType implements StringRepresentable
    {
        NONE("none"),
        FRAME("frame"),
        COVERED("covered");

        public static final Codec<CoverType> CODEC;
        private final String name;

        private CoverType(String name) {
            this.name = name;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }

        public static CoverType byName(String name) {
            for (CoverType bonusType : CoverType.values()) {
                if (!bonusType.name.equals(name)) continue;
                return bonusType;
            }
            return NONE;
        }

        static {
            CODEC = StringRepresentable.m_216439_(CoverType::values);
        }
    }

    public static enum PipeType {
        IMPAIRED,
        STANDARD,
        IMPROVED,
        CREATIVE;

    }
}

