/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.ElementStorageHelper;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.transfer.ElementTransfererHelper;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPathNode;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgradeHelper;
import sirttas.elementalcraft.block.pipe.upgrade.priority.PipePriorityRingsPipeUpgrade;
import sirttas.elementalcraft.config.ECConfig;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class ElementPipeTransferer
implements IElementTransferer {
    private static final Collection<ElementPipeTransferer> TRANSFERERS = new ReferenceOpenHashSet();
    final ElementPipeBlockEntity pipe;
    final Map<Direction, ConnectionType> connections;
    final Map<Direction, PipeUpgrade> upgrades;
    final Comparator<Map.Entry<Direction, ConnectionType>> comparator;
    final int maxTransferAmount;
    private boolean initialized;
    int transferedAmount;

    ElementPipeTransferer(ElementPipeBlockEntity pipe) {
        this.pipe = pipe;
        this.initialized = pipe.m_58900_().m_60713_((Block)ECBlocks.PIPE_CREATIVE.get());
        this.connections = new EnumMap<Direction, ConnectionType>(Direction.class);
        for (Direction direction : Direction.values()) {
            this.connections.put(direction, ConnectionType.NONE);
        }
        this.upgrades = new EnumMap<Direction, PipeUpgrade>(Direction.class);
        this.comparator = this.creatComparator();
        this.maxTransferAmount = switch (((ElementPipeBlock)pipe.m_58900_().m_60734_()).getType()) {
            default -> throw new IncompatibleClassChangeError();
            case ElementPipeBlock.PipeType.IMPAIRED -> (Integer)ECConfig.COMMON.impairedPipeTransferAmount.get();
            case ElementPipeBlock.PipeType.STANDARD -> (Integer)ECConfig.COMMON.pipeTransferAmount.get();
            case ElementPipeBlock.PipeType.IMPROVED -> (Integer)ECConfig.COMMON.improvedPipeTransferAmount.get();
            case ElementPipeBlock.PipeType.CREATIVE -> Integer.MAX_VALUE;
        };
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<ElementPipeTransferer> it = TRANSFERERS.iterator();
            while (it.hasNext()) {
                ElementPipeTransferer transferer = it.next();
                if (transferer.pipe.m_58901_()) {
                    it.remove();
                    continue;
                }
                transferer.transferedAmount = 0;
            }
        }
    }

    private Comparator<Map.Entry<Direction, ConnectionType>> creatComparator() {
        Comparator cmp = (c1, c2) -> Boolean.compare(this.isPriority((Direction)c1.getKey()), this.isPriority((Direction)c2.getKey()));
        return cmp.thenComparingInt(c -> ((ConnectionType)((Object)((Object)c.getValue()))).getValue());
    }

    public boolean isPriority(Direction face) {
        if (this.getUpgrade(face) instanceof PipePriorityRingsPipeUpgrade) {
            return true;
        }
        Level level = this.pipe.m_58904_();
        if (level == null) {
            return false;
        }
        Direction opposite = face.m_122424_();
        return BlockEntityHelper.getBlockEntity((BlockGetter)level, this.pipe.m_58899_().m_121945_(face)).flatMap(p -> ElementTransfererHelper.get((ICapabilityProvider)p, opposite).resolve()).filter(ElementPipeTransferer.class::isInstance).map(ElementPipeTransferer.class::cast).map(t -> t.getUpgrade(opposite)).filter(PipePriorityRingsPipeUpgrade.class::isInstance).isPresent();
    }

    public ConnectionType getConnection(Direction face) {
        return this.connections.getOrDefault(face, ConnectionType.NONE);
    }

    public Map<Direction, ConnectionType> getConnections() {
        return this.connections;
    }

    void init() {
        if (this.initialized) {
            return;
        }
        Level level = this.pipe.m_58904_();
        if (level == null || level.m_5776_()) {
            return;
        }
        TRANSFERERS.add(this);
        this.initialized = true;
    }

    @Override
    public List<IElementTransferPathNode> getConnectedNodes(@Nonnull ElementType type) {
        BlockPos pipePos = this.pipe.m_58899_();
        Level level = this.pipe.m_58904_();
        return this.connections.entrySet().stream().sorted(this.comparator).mapMulti((entry, downstream) -> {
            Direction side = (Direction)entry.getKey();
            ConnectionType connection = (ConnectionType)((Object)((Object)entry.getValue()));
            PipeUpgrade upgrade = this.getUpgrade(side);
            this.addNodes(level, upgrade != null ? upgrade.getConnections(type, connection) : ElementPipeTransferer.getDefaultPos(pipePos, side, connection), type, side.m_122424_(), connection, (Consumer<IElementTransferPathNode>)downstream);
        }).toList();
    }

    private void addNodes(Level level, List<BlockPos> pos, ElementType type, Direction side, ConnectionType connection, Consumer<IElementTransferPathNode> downstream) {
        pos.forEach(p -> this.createNode(level, (BlockPos)p, type, side, connection).ifPresent(downstream));
    }

    public Optional<IElementTransferPathNode> createNode(Level level, BlockPos pos, ElementType type, Direction side, ConnectionType connection) {
        return BlockEntityHelper.getBlockEntity((BlockGetter)level, pos).map(be -> {
            IElementTransferer transferer = ElementTransfererHelper.get((ICapabilityProvider)be, side).filter(t -> {
                if (t instanceof ElementPipeTransferer) {
                    ElementPipeTransferer elementPipeTransferer = (ElementPipeTransferer)t;
                    PipeUpgrade upgrade = elementPipeTransferer.getUpgrade(side);
                    return upgrade == null || upgrade.canTransfer(type, connection);
                }
                return true;
            }).orElse(null);
            IElementStorage storage = ElementStorageHelper.get((ICapabilityProvider)be, side).filter(s -> s.canPipeInsert(type, side)).orElse(null);
            return new Node(pos, transferer, storage);
        });
    }

    public static List<BlockPos> getDefaultPos(BlockPos pos, Direction face, ConnectionType connection) {
        if (connection == ConnectionType.CONNECT || connection == ConnectionType.INSERT) {
            return List.of(pos.m_121945_(face));
        }
        return Collections.emptyList();
    }

    @Override
    public int getRemainingTransferAmount() {
        if (!this.initialized) {
            return 0;
        }
        return this.maxTransferAmount - this.transferedAmount;
    }

    @Override
    public void onTransfer(@Nonnull ElementType type, int amount, @Nullable BlockPos from, @Nullable BlockPos to) {
        if (to != null) {
            this.connections.forEach((side, connection) -> {
                PipeUpgrade upgrade = this.getUpgrade((Direction)side);
                if (upgrade == null || !upgrade.getConnections(type, (ConnectionType)((Object)connection)).contains(to)) {
                    return;
                }
                upgrade.onTransfer(type, amount, from, to);
            });
        }
        this.transferedAmount += amount;
    }

    @Override
    public boolean isValid() {
        return this.initialized && this.transferedAmount < this.maxTransferAmount && !this.pipe.m_58901_();
    }

    void setConnection(Direction face, ConnectionType type) {
        this.connections.put(face, type);
    }

    public Map<Direction, PipeUpgrade> getUpgrades() {
        return Map.copyOf(this.upgrades);
    }

    public PipeUpgrade getUpgrade(Direction face) {
        return this.upgrades.get(face);
    }

    void setUpgrade(Direction face, PipeUpgrade upgrade) {
        if (upgrade != null) {
            this.upgrades.put(face, upgrade);
        }
    }

    public void removeUpgrade(Direction side) {
        this.upgrades.remove(side);
    }

    void load(CompoundTag compound) {
        for (Direction face : Direction.values()) {
            this.setConnection(face, ConnectionType.fromInteger(compound.m_128451_(face.m_7912_())));
            if (compound.m_128471_(face.m_7912_() + "_priority")) {
                this.setUpgrade(face, new PipePriorityRingsPipeUpgrade(this.pipe, face));
            }
            this.setUpgrade(face, PipeUpgradeHelper.load(this.pipe, face, compound.m_128469_(face.m_7912_() + "_upgrades")));
        }
    }

    CompoundTag save(CompoundTag compound) {
        this.connections.forEach((k, v) -> compound.m_128405_(k.m_7912_(), v.getValue()));
        this.upgrades.forEach((k, v) -> compound.m_128365_(k.m_7912_() + "_upgrades", (Tag)v.save()));
        return compound;
    }

    public record Node(BlockPos pos, IElementTransferer transferer, IElementStorage storage) implements IElementTransferPathNode
    {
        @Override
        public BlockPos getPos() {
            return this.pos;
        }

        @Override
        public IElementTransferer getTransferer() {
            return this.transferer;
        }

        @Override
        public IElementStorage getStorage() {
            return this.storage;
        }
    }
}

