/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade.beam;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.transfer.ElementTransfererHelper;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.ElementPipeTransferer;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeTypes;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.particle.ParticleHelper;

public class ElementBeamPipeUpgrade
extends PipeUpgrade {
    public static final String NAME = "element_beam";
    private static final Map<Direction, VoxelShape> SHAPES = ShapeHelper.directionShapes(Block.m_49796_((double)7.0, (double)9.5, (double)7.0, (double)9.0, (double)14.0, (double)9.0));
    private ElementBeamPipeUpgrade other;
    private boolean linked = false;
    private int transfered = 0;

    public ElementBeamPipeUpgrade(ElementPipeBlockEntity pipe, Direction direction) {
        super((PipeUpgradeType)PipeUpgradeTypes.ELEMENT_BEAM.get(), pipe, direction);
    }

    @Override
    public VoxelShape getShape() {
        return SHAPES.get(this.getDirection());
    }

    @Override
    public boolean replaceSection() {
        return true;
    }

    @Override
    public boolean canPlace(ConnectionType connectionType) {
        return !connectionType.isConnected();
    }

    public boolean isLinked() {
        this.tryLink();
        return this.other != null;
    }

    @Override
    public List<BlockPos> getConnections(ElementType type, ConnectionType connection) {
        this.tryLink();
        return this.other != null ? Collections.singletonList(this.other.getPipe().m_58899_()) : Collections.emptyList();
    }

    @Override
    public boolean canTransfer(ElementType type, ConnectionType connection) {
        this.tryLink();
        return this.other != null;
    }

    @Override
    public void onAdded() {
        this.tryLink();
    }

    private void tryLink() {
        if (!this.linked) {
            this.findOther().ifPresent(b -> {
                Optional<ElementBeamPipeUpgrade> opt = b.findOther();
                if (opt.isPresent() && opt.get() == this) {
                    this.other = b;
                    b.other = this;
                    this.linked = true;
                    b.linked = true;
                }
            });
        }
    }

    @Override
    public void onRemoved() {
        if (this.other != null) {
            this.other.linked = false;
            this.linked = false;
            this.other.other = null;
            this.other = null;
        }
    }

    @Override
    public void onTransfer(ElementType type, int amount, @Nullable BlockPos from, @Nullable BlockPos to) {
        ElementPipeBlockEntity otherPipe;
        ElementPipeBlockEntity pipe = this.getPipe();
        Level level = pipe.m_58904_();
        ElementPipeBlockEntity elementPipeBlockEntity = otherPipe = this.other != null ? this.other.getPipe() : null;
        if (level == null || otherPipe == null || !otherPipe.m_58899_().equals((Object)to) || pipe.isCovered() || otherPipe.isCovered()) {
            return;
        }
        int max = pipe.getMaxTransferAmount();
        this.transfered += amount;
        if (this.transfered < max) {
            return;
        }
        this.transfered -= max;
        if (level.f_46441_.m_188500_() < 0.2) {
            Direction direction = this.getDirection();
            Direction opposite = direction.m_122424_();
            ParticleHelper.createElementFlowParticle(type, level, Vec3.m_82512_((Vec3i)to).m_231075_(opposite, 0.5), Vec3.m_82512_((Vec3i)pipe.m_58899_()).m_231075_(direction, 0.5), level.f_46441_);
        }
    }

    private Optional<ElementBeamPipeUpgrade> findOther() {
        ElementPipeBlockEntity pipe = this.getPipe();
        Level level = pipe.m_58904_();
        if (level == null) {
            return Optional.empty();
        }
        BlockPos.MutableBlockPos pos = pipe.m_58899_().m_122032_();
        Direction direction = this.getDirection();
        Direction opposite = direction.m_122424_();
        Integer range = (Integer)ECConfig.COMMON.elementBeamRange.get();
        for (int i = 0; i < range; ++i) {
            pos.m_122173_(direction);
            Optional<ElementBeamPipeUpgrade> opt = BlockEntityHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos).flatMap(b -> ElementTransfererHelper.get((ICapabilityProvider)b, opposite).resolve()).filter(ElementPipeTransferer.class::isInstance).map(ElementPipeTransferer.class::cast).map(t -> t.getUpgrade(opposite)).filter(ElementBeamPipeUpgrade.class::isInstance).map(ElementBeamPipeUpgrade.class::cast);
            if (!opt.isPresent()) continue;
            return opt;
        }
        return Optional.empty();
    }
}

