/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.entity.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlockEntity;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.SingleItemContainer;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.PureInfusionRecipe;

public class PureInfuserBlockEntity
extends AbstractECCraftingBlockEntity<PureInfuserBlockEntity, PureInfusionRecipe> {
    private static final AbstractECCraftingBlockEntity.Config<PureInfuserBlockEntity, PureInfusionRecipe> CONFIG = new AbstractECCraftingBlockEntity.Config((Supplier<BlockEntityType<?>>)ECBlockEntityTypes.PURE_INFUSER, (Supplier<RecipeType<PureInfusionRecipe>>)ECRecipeTypes.PURE_INFUSION, (Supplier<Integer>)ECConfig.COMMON.pureInfuserTransferSpeed, (Supplier<Integer>)ECConfig.COMMON.pureInfuserMaxRunes);
    private final SingleItemContainer inventory = new SingleItemContainer(this::m_6596_);
    private final Map<Direction, PedestalWrapper> pedestalWrappers = new EnumMap<Direction, PedestalWrapper>(Direction.class);

    public PureInfuserBlockEntity(BlockPos pos, BlockState state) {
        super(CONFIG, pos, state);
        this.pedestalWrappers.put(Direction.NORTH, new PedestalWrapper());
        this.pedestalWrappers.put(Direction.SOUTH, new PedestalWrapper());
        this.pedestalWrappers.put(Direction.WEST, new PedestalWrapper());
        this.pedestalWrappers.put(Direction.EAST, new PedestalWrapper());
    }

    @Override
    public void process() {
        super.process();
        if (this.f_58857_.f_46443_) {
            ParticleHelper.createCraftingParticle(ElementType.NONE, this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_).m_82520_(0.0, 0.7, 0.0), this.f_58857_.f_46441_);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PureInfuserBlockEntity pureInfuser) {
        pureInfuser.refreshPedestals();
        if (!pureInfuser.isPowered()) {
            pureInfuser.makeProgress();
        }
    }

    private void refreshPedestals() {
        this.pedestalWrappers.forEach((d, w) -> {
            if (w.isRemoved()) {
                w.lookupPedestal((Direction)d);
            }
        });
    }

    protected void makeProgress() {
        if (this.recipe != null && this.pedestalWrappers.values().stream().allMatch(w -> !w.isRemoved() && w.progress >= ((PureInfusionRecipe)this.recipe).getElementAmount())) {
            this.process();
            this.resetProgress();
        } else if (this.isRecipeAvailable()) {
            this.pedestalWrappers.forEach(this::makeProgress);
        } else if (this.recipe == null) {
            this.resetProgress();
        }
    }

    @Override
    public boolean isRecipeAvailable() {
        if (this.pedestalWrappers.values().stream().anyMatch(w -> w.getElementType() == ElementType.NONE)) {
            return false;
        }
        return super.isRecipeAvailable();
    }

    private void resetProgress() {
        this.pedestalWrappers.values().forEach(w -> {
            w.progress = 0;
        });
    }

    public ItemStack getStackInPedestal(ElementType type) {
        PedestalBlockEntity pedestal = this.getPedestal(type);
        return pedestal != null ? pedestal.getItem() : ItemStack.f_41583_;
    }

    public PedestalBlockEntity getPedestal(ElementType type) {
        if (type == ElementType.NONE) {
            return null;
        }
        return this.pedestalWrappers.values().stream().filter(w -> w.getElementType() == type).map(w -> w.pedestal).findFirst().orElse(null);
    }

    public ElementType getPedestalElementType(Direction direction) {
        return this.pedestalWrappers.get(direction).getElementType();
    }

    public void emptyPedestals() {
        this.pedestalWrappers.values().forEach(w -> w.setPedestalInventory(ItemStack.f_41583_));
    }

    private void makeProgress(Direction direction, PedestalWrapper wrapper) {
        if (wrapper.isRemoved()) {
            return;
        }
        ElementType type = wrapper.getElementType();
        if (type == ElementType.NONE) {
            return;
        }
        PedestalBlockEntity pedestal = wrapper.pedestal;
        Direction offset = direction.m_122424_();
        int oldProgress = wrapper.progress;
        float transferAmount = Math.min(this.getTransferSpeed(pedestal), (float)((PureInfusionRecipe)this.recipe).getElementAmount() - (float)oldProgress);
        if (transferAmount <= 0.0f) {
            return;
        }
        float preservation = this.runeHandler.getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + pedestal.getRuneHandler().getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + 1.0f;
        float newProgress = (float)oldProgress + (float)pedestal.getElementStorage().extractElement(Math.max(1, Math.round(transferAmount / preservation)), false) * preservation;
        wrapper.progress = Math.round(newProgress);
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && newProgress > 0.0f && this.getProgressRounded(transferAmount, newProgress) > this.getProgressRounded(transferAmount, oldProgress)) {
            ParticleHelper.createElementFlowParticle(type, this.f_58857_, Vec3.m_82512_((Vec3i)this.f_58858_).m_82520_(0.0, 0.7, 0.0), offset, 2.5f, this.f_58857_.f_46441_);
        } else if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    @Override
    public void assemble() {
        this.inventory.m_6836_(0, ((PureInfusionRecipe)this.recipe).assemble(this));
        this.emptyPedestals();
    }

    private float getTransferSpeed(PedestalBlockEntity pedestal) {
        return (float)this.transferSpeed * (this.runeHandler.getBonus(Rune.BonusType.SPEED) + pedestal.getRuneHandler().getBonus(Rune.BonusType.SPEED) + 1.0f);
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.m_8020_(0);
    }

    @Override
    public boolean isRunning() {
        return this.pedestalWrappers.values().stream().anyMatch(w -> !w.isRemoved() && w.progress > 0);
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        int[] progressArray = compound.m_128465_("progress");
        for (int i = 0; i < progressArray.length; ++i) {
            Direction direction = Direction.m_122407_((int)i);
            this.pedestalWrappers.get((Object)direction).progress = progressArray[i];
        }
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128385_("progress", this.pedestalWrappers.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Direction)e.getKey()).m_122416_())).mapToInt(e -> ((PedestalWrapper)e.getValue()).progress).toArray());
    }

    private class PedestalWrapper
    implements IElementTypeProvider {
        private PedestalBlockEntity pedestal = null;
        private int progress = 0;

        public boolean isRemoved() {
            return this.pedestal == null || this.pedestal.m_58901_();
        }

        @Override
        public ElementType getElementType() {
            return this.isRemoved() ? ElementType.NONE : this.pedestal.getElementType();
        }

        public void lookupPedestal(Direction direction) {
            PedestalBlockEntity p;
            BlockEntity be = PureInfuserBlockEntity.this.f_58857_ != null ? PureInfuserBlockEntity.this.f_58857_.m_7702_(PureInfuserBlockEntity.this.f_58858_.m_5484_(direction, 3)) : null;
            this.pedestal = be instanceof PedestalBlockEntity ? (p = (PedestalBlockEntity)be) : null;
        }

        public void setPedestalInventory(ItemStack stack) {
            if (this.isRemoved()) {
                return;
            }
            this.pedestal.getInventory().m_6836_(0, stack);
            this.pedestal.m_6596_();
        }
    }
}

