/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.BooleanUtils;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.renderer.SingleItemRenderer;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserBlockEntity;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlock;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.event.TickHandler;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class PureInfuserRenderer
extends SingleItemRenderer<PureInfuserBlockEntity> {
    public PureInfuserRenderer() {
        super(new Vec3(0.5, 0.9, 0.5));
    }

    public void render(@Nonnull PureInfuserBlockEntity te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        this.renderPedestalShadow(te, partialTicks, matrixStack, buffer);
        super.m_6922_(te, partialTicks, matrixStack, buffer, light, overlay);
    }

    private void renderPedestalShadow(@Nonnull PureInfuserBlockEntity te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer) {
        Map<Direction, ElementType> map;
        List<ElementType> remaining;
        if (BooleanUtils.isTrue((Boolean)((Boolean)ECConfig.CLIENT.renderPedestalShadow.get())) && !te.isRunning() && !(remaining = this.getRemainingElements(map = this.getDirectionMap(te))).isEmpty()) {
            map.entrySet().stream().filter(entry -> entry.getValue() == ElementType.NONE).map(Map.Entry::getKey).forEach(direction -> {
                ElementType type = (ElementType)remaining.get((int)(((float)TickHandler.getTicksInGame() + partialTicks) / 20.0f % (float)remaining.size()));
                Block pedestal = this.getPedestalForType(type);
                if (pedestal != null) {
                    matrixStack.m_85836_();
                    matrixStack.m_85837_((double)direction.m_122429_() * 3.0, 0.0, (double)direction.m_122431_() * 3.0);
                    ECRendererHelper.renderGhost(pedestal.m_49966_(), matrixStack, buffer, te.m_58904_(), te.m_58899_().m_5484_(direction, 3));
                    matrixStack.m_85849_();
                    remaining.remove(type);
                }
            });
        }
    }

    private List<ElementType> getRemainingElements(Map<Direction, ElementType> map) {
        List<ElementType> usedElements = map.values().stream().filter(elementType -> elementType != ElementType.NONE).toList();
        return ElementType.ALL_VALID.stream().filter(type -> !usedElements.contains(type)).collect(Collectors.toList());
    }

    private Map<Direction, ElementType> getDirectionMap(PureInfuserBlockEntity te) {
        EnumMap<Direction, ElementType> map = new EnumMap<Direction, ElementType>(Direction.class);
        map.put(Direction.NORTH, te.getPedestalElementType(Direction.NORTH));
        map.put(Direction.SOUTH, te.getPedestalElementType(Direction.SOUTH));
        map.put(Direction.WEST, te.getPedestalElementType(Direction.WEST));
        map.put(Direction.EAST, te.getPedestalElementType(Direction.EAST));
        return map;
    }

    private Block getPedestalForType(ElementType type) {
        return switch (type) {
            case ElementType.WATER -> (PedestalBlock)ECBlocks.WATER_PEDESTAL.get();
            case ElementType.FIRE -> (PedestalBlock)ECBlocks.FIRE_PEDESTAL.get();
            case ElementType.EARTH -> (PedestalBlock)ECBlocks.EARTH_PEDESTAL.get();
            case ElementType.AIR -> (PedestalBlock)ECBlocks.AIR_PEDESTAL.get();
            default -> null;
        };
    }
}

