/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.renderer.ECRendererHelper;
import sirttas.elementalcraft.tag.ECTags;

@OnlyIn(value=Dist.CLIENT)
public class ShrineRenderer<T extends AbstractShrineBlockEntity>
implements BlockEntityRenderer<T> {
    public void render(T shrine, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        if (((AbstractShrineBlockEntity)shrine).showsRange()) {
            BlockPos pos = shrine.m_58899_();
            LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)bufferSource.m_6299_(RenderType.m_110504_()), (AABB)((AbstractShrineBlockEntity)shrine).getRangeBoundingBox().m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_())), (float)1.0f, (float)1.0f, (float)0.6f, (float)1.0f);
        }
        if (Boolean.TRUE.equals(ECConfig.CLIENT.renderShrineUpgradeShadow.get())) {
            this.renderGhostUpgrades(shrine, poseStack, bufferSource);
        }
    }

    private void renderGhostUpgrades(T shrine, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Level level = shrine.m_58904_();
        if (level == null || player == null) {
            return;
        }
        BlockPos pos = shrine.m_58899_();
        Iterator<ItemStack> iterator = List.of(player.m_21205_(), player.m_21206_()).iterator();
        boolean wasRendered = false;
        while (iterator.hasNext() && !wasRendered) {
            ItemStack stack = iterator.next();
            Item item = stack.m_41720_();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            if (!stack.m_204117_(ECTags.Items.SHRINE_UPGRADES)) continue;
            Block block = blockItem.m_40614_();
            for (Direction direction : ((AbstractShrineBlockEntity)shrine).getUpgradeDirections()) {
                BlockState state;
                BlockPos upgradePos = pos.m_121945_(direction);
                if (!level.m_8055_(upgradePos).m_60795_() || (state = block.m_5573_((BlockPlaceContext)new DirectionalPlaceContext(level, upgradePos, direction.m_122424_(), stack, direction))) == null || !state.m_60710_((LevelReader)level, upgradePos)) continue;
                poseStack.m_85836_();
                poseStack.m_85837_((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
                ECRendererHelper.renderGhost(state, poseStack, bufferSource, level, upgradePos);
                poseStack.m_85849_();
                wasRendered = true;
            }
        }
    }
}

