/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.enderlock;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sirttas.elementalcraft.block.shrine.enderlock.EnderLockShrineBlockEntity;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class EnderLockHandler {
    private static final Multimap<Level, EnderLockShrineBlockEntity> ENDER_LOCK_SHRINES = HashMultimap.create();

    private EnderLockHandler() {
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (!(event instanceof EntityTeleportEvent.TeleportCommand) && !(event instanceof EntityTeleportEvent.SpreadPlayersCommand) && entity instanceof Player && ((player = (Player)entity).m_5833_() || player.m_7500_())) {
            return;
        }
        Collection shrines = ENDER_LOCK_SHRINES.get((Object)entity.f_19853_);
        shrines.removeIf(BlockEntity::m_58901_);
        event.setCanceled(shrines.stream().anyMatch(shrine -> shrine.doLock(entity)));
    }

    public static void add(EnderLockShrineBlockEntity shrine) {
        if (!shrine.m_58901_() && shrine.m_58898_()) {
            ENDER_LOCK_SHRINES.put((Object)shrine.m_58904_(), (Object)shrine);
        }
    }
}

