/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.firepylon;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shape.ECShapes;
import sirttas.elementalcraft.block.shrine.AbstractPylonShrineBlock;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.firepylon.FirePylonBlockEntity;

public class FirePylonBlock
extends AbstractPylonShrineBlock<FirePylonBlockEntity> {
    public static final String NAME = "firepylon";
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private static final VoxelShape BASE = Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape IRON_NORTH = Block.m_49796_((double)7.0, (double)12.0, (double)5.0, (double)9.0, (double)14.0, (double)6.0);
    private static final VoxelShape IRON_SOUTH = Block.m_49796_((double)7.0, (double)12.0, (double)10.0, (double)9.0, (double)14.0, (double)11.0);
    private static final VoxelShape IRON_EAST = Block.m_49796_((double)10.0, (double)12.0, (double)7.0, (double)11.0, (double)14.0, (double)9.0);
    private static final VoxelShape IRON_WEST = Block.m_49796_((double)5.0, (double)12.0, (double)7.0, (double)6.0, (double)14.0, (double)9.0);
    private static final VoxelShape UPPER_BASE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)7.0, (double)10.0);
    private static final VoxelShape UPPER_TOP = Block.m_49796_((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape LOWER_SHAPE = Shapes.m_83124_((VoxelShape)ECShapes.SHRINE_SHAPE, (VoxelShape[])new VoxelShape[]{BASE, IRON_NORTH, IRON_SOUTH, IRON_EAST, IRON_WEST});
    private static final VoxelShape UPPER_SHAPE = Shapes.m_83110_((VoxelShape)UPPER_BASE, (VoxelShape)UPPER_TOP);

    public FirePylonBlock() {
        super(ElementType.FIRE);
    }

    @Override
    public FirePylonBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? (FirePylonBlockEntity)super.newBlockEntity(pos, state) : null;
    }

    @Override
    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @Override
    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        if (!level.f_46443_ && player.m_7500_()) {
            DoublePlantBlock.m_52903_((Level)level, (BlockPos)pos, (BlockState)state, (Player)player);
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? LOWER_SHAPE : UPPER_SHAPE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void doAnimateTick(AbstractShrineBlockEntity shrine, BlockState state, Level world, BlockPos pos, RandomSource rand) {
        double x = (double)pos.m_123341_() + (4.0 + rand.m_188500_() * 7.0) / 16.0;
        double y = (double)pos.m_123342_() + 0.375;
        double z = (double)pos.m_123343_() + (4.0 + rand.m_188500_() * 7.0) / 16.0;
        world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y + 0.5, z, 0.0, 0.0, 0.0);
    }
}

