/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.ore;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.Tags;
import sirttas.elementalcraft.ElementalCraftUtils;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.loot.LootHelper;
import sirttas.elementalcraft.tag.ECTags;

public class OreShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = OreShrineBlockEntity.createKey("oreshrine");
    private boolean hasCrystalHarvest = false;

    public OreShrineBlockEntity(BlockPos pos, BlockState state) {
        super(ECBlockEntityTypes.ORE_SHRINE, pos, state, PROPERTIES_KEY);
    }

    private Optional<BlockPos> findOre() {
        return this.getBlocksInRange().filter(p -> this.f_58857_.m_8055_(p).m_204336_(this.hasCrystalHarvest ? ECTags.Blocks.SHRINES_ORE_HARVESTABLE_CRYSTALS : Tags.Blocks.ORES)).findAny();
    }

    @Override
    public AABB getRangeBoundingBox() {
        if (this.hasUpgrade(ShrineUpgrades.CRYSTAL_HARVEST)) {
            return super.getRangeBoundingBox();
        }
        BlockPos targetPos = this.getTargetPos();
        float range = this.getRange();
        int height = Math.abs(this.f_58857_.m_141937_() - targetPos.m_123342_());
        return ElementalCraftUtils.stitchAABB(new AABB(targetPos).m_82377_((double)range, 0.0, (double)range).m_82386_(0.0, -1.0, 0.0).m_82363_(0.0, 1.0 - (double)height, 0.0));
    }

    @Override
    protected boolean doPeriod() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.hasCrystalHarvest = this.hasUpgrade(ShrineUpgrades.CRYSTAL_HARVEST);
            return this.findOre().map(p -> {
                OreShrineBlockEntity.harvest(serverLevel, p, this, this.hasCrystalHarvest ? Blocks.f_50016_.m_49966_() : Blocks.f_50069_.m_49966_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    public static void harvest(ServerLevel level, BlockPos pos, AbstractShrineBlockEntity shrine, @Nullable BlockState newState) {
        int fortune = shrine.getUpgradeCount(ShrineUpgrades.FORTUNE);
        if (fortune > 0) {
            ItemStack pickaxe = new ItemStack((ItemLike)Items.f_42395_);
            pickaxe.m_41663_(Enchantments.f_44987_, fortune);
            LootHelper.getDrops(level, pos, pickaxe).forEach(s -> Block.m_49840_((Level)level, (BlockPos)shrine.m_58899_().m_7494_(), (ItemStack)s));
        } else {
            LootHelper.getDrops(level, pos, shrine.hasUpgrade(ShrineUpgrades.SILK_TOUCH)).forEach(s -> Block.m_49840_((Level)level, (BlockPos)shrine.m_58899_().m_7494_(), (ItemStack)s));
        }
        if (newState != null && !newState.m_60795_()) {
            level.m_46597_(pos, newState);
        } else {
            level.m_46961_(pos, false);
        }
    }
}

