/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ECConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    private ECConfig() {
    }

    static {
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Common::new);
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        COMMON_SPEC = (ForgeConfigSpec)serverPair.getRight();
        COMMON = (Common)serverPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue tankCapacity;
        public final ForgeConfigSpec.IntValue tankSmallCapacity;
        public final ForgeConfigSpec.IntValue reservoirCapacity;
        public final ForgeConfigSpec.IntValue extractorExtractionAmount;
        public final ForgeConfigSpec.IntValue extractorMaxRunes;
        public final ForgeConfigSpec.IntValue improvedExtractorExtractionAmount;
        public final ForgeConfigSpec.IntValue improvedExtractorMaxRunes;
        public final ForgeConfigSpec.IntValue evaporatorExtractionAmount;
        public final ForgeConfigSpec.IntValue evaporatorMaxRunes;
        public final ForgeConfigSpec.IntValue solarSynthesizerMaxRunes;
        public final ForgeConfigSpec.IntValue solarSynthesizerLensElementMultiplier;
        public final ForgeConfigSpec.IntValue diffuserDiffusionAmount;
        public final ForgeConfigSpec.IntValue diffuserMaxRunes;
        public final ForgeConfigSpec.IntValue diffuserRange;
        public final ForgeConfigSpec.IntValue fireFurnaceTransferSpeed;
        public final ForgeConfigSpec.IntValue fireFurnaceMaxRunes;
        public final ForgeConfigSpec.IntValue fireFurnaceElementAmount;
        public final ForgeConfigSpec.IntValue fireBlastFurnaceTransferSpeed;
        public final ForgeConfigSpec.IntValue fireBlastFurnaceMaxRunes;
        public final ForgeConfigSpec.IntValue fireBlastFurnaceElementAmount;
        public final ForgeConfigSpec.IntValue infuserTransferSpeed;
        public final ForgeConfigSpec.IntValue infuserMaxRunes;
        public final ForgeConfigSpec.IntValue binderTransferSpeed;
        public final ForgeConfigSpec.IntValue binderMaxRunes;
        public final ForgeConfigSpec.IntValue improvedBinderTransferSpeed;
        public final ForgeConfigSpec.IntValue improvedBinderMaxRunes;
        public final ForgeConfigSpec.BooleanValue binderRecipeMatchOrder;
        public final ForgeConfigSpec.IntValue crystallizerTransferSpeed;
        public final ForgeConfigSpec.IntValue crystallizerMaxRunes;
        public final ForgeConfigSpec.DoubleValue crystallizerLuckRatio;
        public final ForgeConfigSpec.IntValue inscriberTransferSpeed;
        public final ForgeConfigSpec.IntValue inscriberMaxRunes;
        public final ForgeConfigSpec.IntValue airMillGrindstoneTransferSpeed;
        public final ForgeConfigSpec.IntValue airMillGrindstoneMaxRunes;
        public final ForgeConfigSpec.IntValue waterMillWoodSawTransferSpeed;
        public final ForgeConfigSpec.IntValue waterMillWoodSawMaxRunes;
        public final ForgeConfigSpec.IntValue purifierTransferSpeed;
        public final ForgeConfigSpec.IntValue purifierMaxRunes;
        public final ForgeConfigSpec.BooleanValue pureOreRecipeInjection;
        public final ForgeConfigSpec.IntValue impairedPipeTransferAmount;
        public final ForgeConfigSpec.IntValue pipeTransferAmount;
        public final ForgeConfigSpec.IntValue improvedPipeTransferAmount;
        public final ForgeConfigSpec.BooleanValue pipePathCache;
        public final ForgeConfigSpec.IntValue elementBeamRange;
        public final ForgeConfigSpec.DoubleValue elementPumpMultiplier;
        public final ForgeConfigSpec.DoubleValue elementPumpWaste;
        public final ForgeConfigSpec.IntValue elementPumpMaxRunes;
        public final ForgeConfigSpec.IntValue sorterCooldown;
        public final ForgeConfigSpec.IntValue sorterMaxItem;
        public final ForgeConfigSpec.IntValue sorterMaxRunes;
        public final ForgeConfigSpec.IntValue pureInfuserTransferSpeed;
        public final ForgeConfigSpec.IntValue pureInfuserMaxRunes;
        public final ForgeConfigSpec.IntValue pedestalCapacity;
        public final ForgeConfigSpec.IntValue pedestalMaxRunes;
        public final ForgeConfigSpec.IntValue sourceBreederTransferSpeed;
        public final ForgeConfigSpec.IntValue sourceBreederMaxRunes;
        public final ForgeConfigSpec.IntValue sourceBreedingBaseCost;
        public final ForgeConfigSpec.IntValue sourceBreederPedestalCapacity;
        public final ForgeConfigSpec.IntValue sourceBreederPedestalMaxRunes;
        public final ForgeConfigSpec.IntValue elementHolderCapacity;
        public final ForgeConfigSpec.IntValue elementHolderTransferAmount;
        public final ForgeConfigSpec.IntValue pureElementHolderCapacity;
        public final ForgeConfigSpec.IntValue pureElementHolderTransferAmount;
        public final ForgeConfigSpec.IntValue focusMaxSpell;
        public final ForgeConfigSpec.IntValue spellBookMaxSpell;
        public final ForgeConfigSpec.BooleanValue playersSpawnWithBook;
        public final ForgeConfigSpec.IntValue shardElementAmount;
        public final ForgeConfigSpec.BooleanValue disableSourceSpawn;
        public final ForgeConfigSpec.IntValue sourceSpawnCount;
        public final ForgeConfigSpec.BooleanValue spellConsumeOnFail;
        public final ForgeConfigSpec.BooleanValue disableSourceExhaustion;
        public final ForgeConfigSpec.IntValue manaSynthesizerMaxRunes;
        public final ForgeConfigSpec.IntValue manaSynthesizerManaCapacity;
        public final ForgeConfigSpec.DoubleValue manaElementRatio;
        public final ForgeConfigSpec.IntValue manaSynthesizerLensElementMultiplier;
        public final ForgeConfigSpec.IntValue mekanismPureOreInputMultiplier;
        public final ForgeConfigSpec.IntValue mekanismPureOreOutputMultiplier;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("ElementalCraft config").push("elementalcraft");
            builder.comment("Instruments config").push("instruments").push("tank");
            this.tankSmallCapacity = builder.comment("The element capacity of a small element container.").defineInRange("tankSmallCapacity", 1000, 0, 100000000);
            this.tankCapacity = builder.comment("The element capacity of a element container.").defineInRange("tankCapacity", 100000, 0, 100000000);
            this.reservoirCapacity = builder.comment("The element capacity of a element reservoir.").defineInRange("reservoirCapacity", 5000000, 0, 100000000);
            builder.pop().push("extractor");
            this.extractorExtractionAmount = builder.comment("The amount of element extracted by an extractor.").defineInRange("extractorExtractionAmount", 5, 0, 100);
            this.extractorMaxRunes = builder.comment("The max amount ofrunes on an extractor.").defineInRange("extractorMaxRunes", 1, 0, 10);
            this.improvedExtractorExtractionAmount = builder.comment("The amount of element extracted by an improved extractor.").defineInRange("improvedExtractorExtractionAmount", 25, 0, 500);
            this.improvedExtractorMaxRunes = builder.comment("The max amount of runes on an improved extracto.").defineInRange("improvedExtractoMaxRunes", 3, 0, 10);
            builder.pop().push("evaporator");
            this.evaporatorExtractionAmount = builder.comment("The amount of element extracted by an evaporator.").defineInRange("evaporatorExtractionAmount", 1, 0, 100);
            this.evaporatorMaxRunes = builder.comment("The max amount of runes on an evaporator.").defineInRange("evaporatorMaxRunes", 1, 0, 10);
            builder.pop().push("solarSynthesizer");
            this.solarSynthesizerMaxRunes = builder.comment("The max amount of runes on a Solar Synthesizer.").defineInRange("solarSynthesizerMaxRunes", 2, 0, 10);
            this.solarSynthesizerLensElementMultiplier = builder.comment("the multiplier of lens in the Solar Synthesizer (based on 1500)").defineInRange("solarSynthesizerLensElementMultiplier", 10, 0, 100);
            builder.pop().push("diffuser");
            this.diffuserDiffusionAmount = builder.comment("The amount of element transfered by a diffuser.").defineInRange("diffuserDiffusionAmount", 5, 0, 100);
            this.diffuserMaxRunes = builder.comment("The max amount of runes on a diffuser.").defineInRange("diffuserMaxRunes", 3, 0, 10);
            this.diffuserRange = builder.comment("The range of a diffuser.").defineInRange("diffuserRange", 10, 0, 100);
            builder.pop().push("fireFurnace");
            this.fireFurnaceTransferSpeed = builder.comment("The max amount of element consumed by the fire furnace per tick.").defineInRange("fireFurnaceTransferSpeed", 10, 0, 1000);
            this.fireFurnaceMaxRunes = builder.comment("The max amount of runes on a fire furnace.").defineInRange("fireFurnaceMaxRunes", 2, 0, 10);
            this.fireFurnaceElementAmount = builder.comment("The amount multiplied by the cooking time of the furnace recipe.").defineInRange("fireFurnaceElementAmount", 5, 0, 1000);
            builder.push("fireBlastFurnace");
            this.fireBlastFurnaceTransferSpeed = builder.comment("The max amount of element consumed by the fire blast furnace per tick.").defineInRange("fireBlastFurnaceTransferSpeed", 20, 0, 1000);
            this.fireBlastFurnaceMaxRunes = builder.comment("The max amount of runes on a fire blast furnace.").defineInRange("fireBlastFurnaceMaxRunes", 3, 0, 10);
            this.fireBlastFurnaceElementAmount = builder.comment("The amount multiplied by the cooking time of the blast furnace recipe.").defineInRange("fireBlastFurnaceElementAmount", 10, 0, 1000);
            builder.pop(2).push("infuser");
            this.infuserTransferSpeed = builder.comment("The max amount of element consumed by the infuser per tick.").defineInRange("infuserTransferSpeed", 10, 0, 1000);
            this.infuserMaxRunes = builder.comment("The max amount of runes on an infuser.").defineInRange("infuserMaxRunes", 1, 0, 10);
            builder.pop().push("binder");
            this.binderTransferSpeed = builder.comment("The max amount of element consumed by the binder per tick.").defineInRange("binderTransferSpeed", 25, 0, 1000);
            this.binderMaxRunes = builder.comment("The max amount of runes on an binder.").defineInRange("binderMaxRunes", 2, 0, 10);
            this.binderRecipeMatchOrder = builder.comment("Define if or not binder recip require to be ordered.").define("binderRecipeMatchOrder", true);
            builder.push("improved");
            this.improvedBinderTransferSpeed = builder.comment("The max amount of element consumed by the improved binder per tick.").defineInRange("improvedBinderTransferSpeed", 50, 0, 1000);
            this.improvedBinderMaxRunes = builder.comment("The max amount of runes on an improved binder.").defineInRange("improvedBinderMaxRunes", 3, 0, 10);
            builder.pop(2).push("crystallizer");
            this.crystallizerTransferSpeed = builder.comment("The max amount of element consumed by the gem crystallizer per tick.").defineInRange("crystallizerTransferSpeed", 25, 0, 1000);
            this.crystallizerMaxRunes = builder.comment("The max amount of runes on an crystallizer.").defineInRange("crystallizerMaxRunes", 3, 0, 10);
            this.crystallizerLuckRatio = builder.comment("The ratio of each luck rune on a crystallizer.").defineInRange("crystallizerLuckRatio", 3.0, 0.0, 10.0);
            builder.pop().push("inscriber");
            this.inscriberTransferSpeed = builder.comment("The max amount of element consumed by the gem inscriber per tick.").defineInRange("inscriberTransferSpeed", 1000, 0, 10000);
            this.inscriberMaxRunes = builder.comment("The max amount of runes on an inscriber.").defineInRange("inscriberMaxRunes", 3, 0, 10);
            builder.pop().push("airMillGrindstone");
            this.airMillGrindstoneTransferSpeed = builder.comment("The max amount of element consumed by the Air Mill Grindstone per tick.").defineInRange("airMillGrindstoneTransferSpeed", 10, 0, 1000);
            this.airMillGrindstoneMaxRunes = builder.comment("The max amount of runes on an Air Mill Grindstone.").defineInRange("airMillGrindstoneMaxRunes", 3, 0, 10);
            builder.pop().push("waterMillWoodSaw");
            this.waterMillWoodSawTransferSpeed = builder.comment("The max amount of element consumed by the Water Mill Wood Saw per tick.").defineInRange("waterMillWoodSawTransferSpeed", 10, 0, 1000);
            this.waterMillWoodSawMaxRunes = builder.comment("The max amount of runes on an Water Mill Wood Saw.").defineInRange("waterMillWoodSawMaxRunes", 3, 0, 10);
            builder.pop().push("purifier");
            this.purifierTransferSpeed = builder.comment("The max amount of element consumed by the Ore Purifier per tick.").defineInRange("purifierTransferSpeed", 25, 0, 1000);
            this.purifierMaxRunes = builder.comment("The max amount of runes on an purifier.").defineInRange("purifierMaxRunes", 3, 0, 10);
            builder.push("pureOre");
            this.pureOreRecipeInjection = builder.comment("Set to false if you want to manually manage processing of pure ore.").define("pureOreRecipeInjection", true);
            builder.pop(2).push("elementPipe");
            this.impairedPipeTransferAmount = builder.comment("The amount of element transferred by impaired pipes.").defineInRange("impairedPipeTransferAmount", 5, 0, 10000);
            this.pipeTransferAmount = builder.comment("The amount of element transferred by pipes.").defineInRange("pipeTransferAmount", 25, 0, 10000);
            this.improvedPipeTransferAmount = builder.comment("The amount of element transferred by improved pipes.").defineInRange("improvedPipeTransferAmount", 100, 0, 10000);
            this.pipePathCache = builder.comment("Cache the last path used by the pipe to increase performances.").define("pipePathCache", true);
            builder.push("upgrade").push("elementBeam");
            this.elementBeamRange = builder.comment("The range of the element beam.").defineInRange("elementBeamRange", 10, 0, 100);
            builder.pop().push("elementPump");
            this.elementPumpMultiplier = builder.comment("The amount of element pumped by the element pump.").defineInRange("elementPumpMultiplier", 5.0, 0.0, 100.0);
            this.elementPumpWaste = builder.comment("The amount of element wasted by the element pump.").defineInRange("elementPumpWaste", 0.1, 0.0, 1.0);
            this.elementPumpMaxRunes = builder.comment("The max amount of runes an element pump can have.").defineInRange("elementPumpMaxRunes", 3, 0, 10);
            builder.pop(3).push("sorter");
            this.sorterCooldown = builder.comment("The amount of tick between two ordered sorter item transfer.").defineInRange("sorterCooldown", 10, 0, 100);
            this.sorterMaxItem = builder.comment("The max amount of items an order sorter can filter.").defineInRange("sorterMaxItem", 15, 0, 100);
            this.sorterMaxRunes = builder.comment("The max amount of runes an order sorter can have.").defineInRange("sorterMaxRunes", 3, 0, 10);
            builder.pop(2).comment("Pure Infuser and pedestals config").push("pureInfuser");
            this.pureInfuserTransferSpeed = builder.comment("The max amount of element consumed by the pure infuser per tick.").defineInRange("pureInfuserTransferSpeed", 100, 0, 1000);
            this.pureInfuserMaxRunes = builder.comment("The max amount of runes on a pure infuser.").defineInRange("pureInfuserMaxRunes", 3, 0, 10);
            builder.push("pedestals");
            this.pedestalMaxRunes = builder.comment("The max amount of runes on a pedestal.").defineInRange("pedestalMaxRunes", 1, 0, 10);
            this.pedestalCapacity = builder.comment("The element capacity of a pedestal.").defineInRange("pedestalCapacity", 10000, 0, 100000000);
            builder.pop(2).comment("Source Breeder and pedestals config").push("sourceBreeder");
            this.sourceBreederTransferSpeed = builder.comment("The max amount of element consumed by the source breeder per tick.").defineInRange("sourceBreederTransferSpeed", 500, 0, 1000);
            this.sourceBreederMaxRunes = builder.comment("The max amount of runes on a source breeder.").defineInRange("sourceBreederMaxRunes", 3, 0, 10);
            this.sourceBreedingBaseCost = builder.comment("The base cost of breeding sources.").defineInRange("sourceBreedingBaseCost", 500000, 0, 100000000);
            builder.push("pedestals");
            this.sourceBreederPedestalMaxRunes = builder.comment("The max amount of runes on a source breeder pedestal.").defineInRange("sourceBreederPedestalMaxRunes", 1, 0, 10);
            this.sourceBreederPedestalCapacity = builder.comment("The element capacity of a source breeder pedestal.").defineInRange("sourceBreederPedestalCapacity", 100000, 0, 100000000);
            builder.pop(2).comment("Items config").push("items");
            builder.push("elementHolder");
            this.elementHolderCapacity = builder.comment("The element capacity of an element holder.").defineInRange("elementHolderCapacity", 10000, 0, 100000000);
            this.elementHolderTransferAmount = builder.comment("The amount of element transferred by an element holder.").defineInRange("elementHolderTransferAmount", 25, 0, 1000);
            builder.push("pure");
            this.pureElementHolderCapacity = builder.comment("The element capacity of a pure element holder.").defineInRange("pureElementHolderCapacity", 100000, 0, 100000000);
            this.pureElementHolderTransferAmount = builder.comment("The amount of element transferred by a pure element holder.").defineInRange("pureElementHolderTransferAmount", 100, 0, 1000);
            builder.pop(2);
            this.focusMaxSpell = builder.comment("The max number of spells on a focus.").defineInRange("focusMaxSpell", 10, 1, 20);
            this.spellBookMaxSpell = builder.comment("The max number of spells on an elementalist grimoire.").defineInRange("spellBookMaxSpell", 100, 1, 1000);
            this.playersSpawnWithBook = builder.comment("Players start the game with an elementopedia in their inventory.").define("playersSpawnWithBook", false);
            this.shardElementAmount = builder.comment("The amount of element contained in a single shard.").defineInRange("shardElementAmount", 250, 0, 1000);
            builder.pop().comment("Spell config").push("spell");
            this.spellConsumeOnFail = builder.comment("Define if a spell will be cast (and destroyed) or not if you dont have enought element.").define("spellConsumeOnFail", false);
            builder.pop().comment("Source config").push("source");
            this.disableSourceExhaustion = builder.comment("set to true to make sources infinite.").define("disableSourceExhaustion", false);
            builder.pop().comment("Config of sources around").push("spawn");
            this.disableSourceSpawn = builder.comment("Disable creation of sources.").define("disableSourceSpawn", false);
            this.sourceSpawnCount = builder.comment("number of sources at spawn per element type.").defineInRange("sourceSpawnCount", 2, 1, 20);
            builder.pop(2).comment("mod interaction config").push("interaction");
            builder.push("botania").push("manaSynthesizer");
            this.manaSynthesizerMaxRunes = builder.comment("The max amount of runes on a Mana Synthesizer.").defineInRange("manaSynthesizerMaxRunes", 2, 0, 10);
            this.manaSynthesizerManaCapacity = builder.comment("The mana capacity of the Mana Synthesizer.").defineInRange("manaSynthesizerManaCapacity", 10000, 0, 1000000);
            this.manaSynthesizerLensElementMultiplier = builder.comment("the multiplier of lens in the Mana Synthesizer (based on 1500)").defineInRange("manaSynthesizerLensElementMultiplier", 50, 0, 100);
            this.manaElementRatio = builder.comment("The amount of element 1 mana is worth.").defineInRange("manaElementRatio", 0.1, 0.0, 100.0);
            builder.pop(2).push("mekanism");
            this.mekanismPureOreInputMultiplier = builder.comment("The amount multiplier when using pure ore in mekanism.").defineInRange("mekanismPureOreInputMultiplier", 5, 0, 20);
            this.mekanismPureOreOutputMultiplier = builder.comment("The amount multiplier when using pure ore in mekanism.").defineInRange("mekanismPureOreOutputMultiplier", 3, 0, 20);
            builder.pop(2);
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue usePaleElementGauge;
        public final ForgeConfigSpec.IntValue shrineRangeDisplayDuration;
        public final ForgeConfigSpec.BooleanValue renderPedestalShadow;
        public final ForgeConfigSpec.BooleanValue renderShrineUpgradeShadow;
        public final ForgeConfigSpec.BooleanValue renderInstrumentShadow;
        public final ForgeConfigSpec.BooleanValue fastParticleEffects;
        public final ForgeConfigSpec.IntValue gaugeOffsetX;
        public final ForgeConfigSpec.IntValue gaugeOffsetY;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("ElementalCraft client config").push("elementalcraft-client");
            this.shrineRangeDisplayDuration = builder.comment("The duration of shrine range display.").defineInRange("shrineRangeDisplayDuration", 600, 0, 10000);
            this.fastParticleEffects = builder.comment("Set to true if you want to reduce quality of particles for beter performances.").define("fastParticleEffects", false);
            builder.push("shadowBlocks");
            this.renderPedestalShadow = builder.comment("Display a shadow where pedestals can be placed.").define("renderPedestalShadow", true);
            this.renderShrineUpgradeShadow = builder.comment("Display a shadow where shrine upgrades can be placed.").define("renderShrineUpgradeShadow", true);
            this.renderInstrumentShadow = builder.comment("Display a shadow where instruments can be placed.").define("renderInstrumentShadow", true);
            builder.pop().push("gauge");
            this.usePaleElementGauge = builder.comment("Use pale element gauges.").define("usePaleElementGauge", false);
            this.gaugeOffsetX = builder.comment("the offset of the gauge on the X axis.").defineInRange("gaugeOffsetX", 0, -10000, 10000);
            this.gaugeOffsetY = builder.comment("the offset of the gauge on the Y axis.").defineInRange("gaugeOffsetY", 0, -10000, 10000);
            builder.pop();
        }
    }
}

