/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.elemental;

import net.minecraft.world.item.Item;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.source.displacement.plate.SourceDisplacementPlateBlock;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.elemental.CrystalItem;
import sirttas.elementalcraft.item.elemental.ShardItem;

public class ElementalItemHelper {
    public static final String ERROR_MESSAGE = "Element Type must not be NONE";

    private ElementalItemHelper() {
    }

    public static Item getCrystalForType(ElementType type) {
        return switch (type) {
            case ElementType.AIR -> (CrystalItem)ECItems.AIR_CRYSTAL.get();
            case ElementType.EARTH -> (CrystalItem)ECItems.EARTH_CRYSTAL.get();
            case ElementType.FIRE -> (CrystalItem)ECItems.FIRE_CRYSTAL.get();
            case ElementType.WATER -> (CrystalItem)ECItems.WATER_CRYSTAL.get();
            default -> (ECItem)((Object)ECItems.INERT_CRYSTAL.get());
        };
    }

    public static Item getShardForType(ElementType type) {
        return switch (type) {
            case ElementType.AIR -> (ShardItem)ECItems.AIR_SHARD.get();
            case ElementType.EARTH -> (ShardItem)ECItems.EARTH_SHARD.get();
            case ElementType.FIRE -> (ShardItem)ECItems.FIRE_SHARD.get();
            case ElementType.WATER -> (ShardItem)ECItems.WATER_SHARD.get();
            default -> throw new IllegalArgumentException(ERROR_MESSAGE);
        };
    }

    public static Item getPowerfulShardForType(ElementType type) {
        return switch (type) {
            case ElementType.AIR -> (ShardItem)ECItems.POWERFUL_AIR_SHARD.get();
            case ElementType.EARTH -> (ShardItem)ECItems.POWERFUL_EARTH_SHARD.get();
            case ElementType.FIRE -> (ShardItem)ECItems.POWERFUL_FIRE_SHARD.get();
            case ElementType.WATER -> (ShardItem)ECItems.POWERFUL_WATER_SHARD.get();
            default -> throw new IllegalArgumentException(ERROR_MESSAGE);
        };
    }

    public static Item getDisplacementPlate(ElementType type) {
        return switch (type) {
            case ElementType.AIR -> ((SourceDisplacementPlateBlock)ECBlocks.AIR_SOURCE_DISPLACEMENT_PLATE.get()).m_5456_();
            case ElementType.EARTH -> ((SourceDisplacementPlateBlock)ECBlocks.EARTH_SOURCE_DISPLACEMENT_PLATE.get()).m_5456_();
            case ElementType.FIRE -> ((SourceDisplacementPlateBlock)ECBlocks.FIRE_SOURCE_DISPLACEMENT_PLATE.get()).m_5456_();
            case ElementType.WATER -> ((SourceDisplacementPlateBlock)ECBlocks.WATER_SOURCE_DISPLACEMENT_PLATE.get()).m_5456_();
            default -> throw new IllegalArgumentException(ERROR_MESSAGE);
        };
    }
}

