/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source.analysis;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.api.source.ISourceInteractable;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.source.analysis.SourceAnalysisGlassMenu;
import sirttas.elementalcraft.property.ECProperties;

public class SourceAnalysisGlassItem
extends ECItem
implements ISourceInteractable {
    public static final String NAME = "source_analysis_glass";

    public SourceAnalysisGlassItem() {
        super(ECProperties.Items.ITEM_UNSTACKABLE);
    }

    public static boolean consumeSpringaline(Player player) {
        ItemStack stack;
        if (player == null || player.m_150110_().f_35937_) {
            return true;
        }
        Inventory inv = player.m_150109_();
        int slot = inv.m_36030_(new ItemStack((ItemLike)ECItems.SPRINGALINE_SHARD.get()));
        if (slot >= 0 && !(stack = inv.m_8020_(slot)).m_41619_()) {
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                inv.m_6836_(slot, ItemStack.f_41583_);
            }
            return true;
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.elementalcraft.missing_springaline"), true);
        return false;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        return BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, SourceBlockEntity.class).map(source -> {
            if (source.isAnalyzed() || SourceAnalysisGlassItem.consumeSpringaline(player)) {
                source.setAnalyzed(true);
                return this.open(level, player, source.getTraitHolder().getTraits());
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    public InteractionResult open(Level world, Player player, Map<ResourceKey<SourceTrait>, ISourceTraitValue> traitMap) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_((MenuProvider)new Menu(traitMap));
        return InteractionResult.CONSUME;
    }

    private class Menu
    implements MenuProvider {
        private final Map<ResourceKey<SourceTrait>, ISourceTraitValue> traits;

        private Menu(Map<ResourceKey<SourceTrait>, ISourceTraitValue> traits) {
            this.traits = traits;
        }

        public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new SourceAnalysisGlassMenu(id, inventory, this.traits);
        }

        @Nonnull
        public Component m_5446_() {
            return SourceAnalysisGlassItem.this.m_41466_();
        }
    }
}

