/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.spell.book;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.menu.AbstractECMenu;
import sirttas.elementalcraft.container.menu.ECMenus;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.spell.book.SpellBookMessage;
import sirttas.elementalcraft.network.message.MessageHelper;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;

public class SpellBookMenu
extends AbstractECMenu {
    static final int ROW_COUNT = (Spells.REGISTRY.get().getEntries().size() + 9 - 1) / 9;
    static final int SLOT_COUNT = ROW_COUNT * 9;
    private ItemStack book;
    private final Container inventory;
    private final Player player;

    public SpellBookMenu(int id, Inventory player) {
        this(id, player, new ItemStack((ItemLike)ECItems.SPELL_BOOK.get()));
    }

    private SpellBookMenu(int id, Inventory playerInventoryIn, ItemStack book) {
        super(ECMenus.SPELL_BOOK, id);
        this.book = book;
        this.inventory = new SimpleContainer(SLOT_COUNT);
        this.player = playerInventoryIn.f_35978_;
        this.addSlots(playerInventoryIn);
    }

    public static SpellBookMenu create(int id, Inventory playerInventoryIn, ItemStack book) {
        return new SpellBookMenu(id, playerInventoryIn, book);
    }

    private void addSlots(Inventory playerInventoryIn) {
        for (int i = 0; i < ROW_COUNT; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new ScrollSlot(this.inventory, j + i * 9, 8 + j * 18, 18 + i * 18));
            }
        }
        this.addPlayerSlots(playerInventoryIn, 103 + (ROW_COUNT - 4) * 18);
    }

    public boolean m_5622_(Slot slotIn) {
        return slotIn.f_40219_ > SLOT_COUNT;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            ItemStack old = stack.m_41777_();
            Spell spell = SpellHelper.getSpell(stack);
            if (stack.m_150930_((Item)ECItems.SCROLL.get()) && spell.isValid()) {
                if (index < SLOT_COUNT) {
                    this.removeSpell(stack);
                    return ItemStack.f_41583_;
                }
                if (this.canAddSpell(stack, spell)) {
                    this.addSpell(stack, spell);
                    return ItemStack.f_41583_;
                }
                if (stack.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                return old;
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player player) {
        Slot slot;
        Slot slot2 = slot = slotId >= 0 ? (Slot)this.f_38839_.get(slotId) : null;
        if (slot == null || !slot.m_7993_().m_150930_((Item)ECItems.SPELL_BOOK.get())) {
            if (slotId < 0 || slotId >= SLOT_COUNT || clickTypeIn == ClickType.THROW || clickTypeIn == ClickType.QUICK_MOVE || clickTypeIn == ClickType.PICKUP_ALL) {
                super.m_150399_(slotId, dragType, clickTypeIn, player);
            } else if (clickTypeIn == ClickType.CLONE && player.m_150110_().f_35937_ && this.m_142621_().m_41619_()) {
                if (slot != null && slot.m_6657_()) {
                    ItemStack scroll = slot.m_7993_().m_41777_();
                    scroll.m_41764_(1);
                    this.m_142503_(scroll);
                }
            } else if (clickTypeIn == ClickType.PICKUP) {
                if (this.m_142621_().m_41619_()) {
                    if (slot != null && slot.m_6657_()) {
                        ItemStack stack = slot.m_7993_();
                        ItemStack scroll = stack.m_41777_();
                        stack.m_41774_(1);
                        scroll.m_41764_(1);
                        SpellHelper.removeSpell(this.book, SpellHelper.getSpell(stack));
                        this.m_142503_(scroll);
                        this.refresh();
                    }
                } else {
                    ItemStack stack = this.m_142621_();
                    Spell spell = SpellHelper.getSpell(stack);
                    if (stack.m_150930_((Item)ECItems.SCROLL.get()) && spell.isValid()) {
                        SpellHelper.addSpell(this.book, spell);
                        this.m_142503_(ItemStack.f_41583_);
                        this.refresh();
                    }
                }
            }
        }
    }

    public int getSpellCount() {
        int spellCount = SpellHelper.getSpellCount(this.book);
        return spellCount > 0 ? spellCount : IntStream.range(0, SLOT_COUNT).map(i -> {
            ItemStack stack = this.inventory.m_8020_(i);
            return stack.m_41619_() ? 0 : stack.m_41613_();
        }).sum();
    }

    public void setBook(ItemStack book) {
        this.book = book;
        this.refresh();
    }

    public boolean canAddSpell(ItemStack stack, Spell spell) {
        return stack.m_150930_((Item)ECItems.SCROLL.get()) && spell.isValid() && SpellHelper.getSpellCount(stack) < (Integer)ECConfig.COMMON.spellBookMaxSpell.get();
    }

    @Override
    public void onOpen(Player player) {
        this.refresh();
    }

    private void refresh() {
        List<Pair<Spell, Integer>> spells = SpellHelper.getSpellsAsMap(this.book);
        for (int i = 0; i < SLOT_COUNT; ++i) {
            if (i < spells.size()) {
                ItemStack scroll = new ItemStack((ItemLike)ECItems.SCROLL.get());
                Pair<Spell, Integer> pair = spells.get(i);
                SpellHelper.setSpell(scroll, (Spell)pair.getFirst());
                scroll.m_41764_(((Integer)pair.getSecond()).intValue());
                this.inventory.m_6836_(i, scroll);
            } else {
                this.inventory.m_6836_(i, ItemStack.f_41583_);
            }
            this.f_38839_.forEach(Slot::m_6654_);
        }
        if (this.player instanceof ServerPlayer) {
            MessageHelper.sendToPlayer((ServerPlayer)this.player, new SpellBookMessage(this.book));
        }
    }

    private void removeSpell(ItemStack stack) {
        Spell spell = SpellHelper.getSpell(stack);
        if (spell.isValid()) {
            for (int i = 0; i < this.f_38839_.size(); ++i) {
                Slot slot = (Slot)this.f_38839_.get(i + SLOT_COUNT);
                if (slot.m_6657_()) continue;
                ItemStack scroll = new ItemStack((ItemLike)ECItems.SCROLL.get());
                SpellHelper.setSpell(scroll, spell);
                slot.m_5852_(scroll);
                stack.m_41774_(1);
                SpellHelper.removeSpell(this.book, spell);
                slot.m_6654_();
                this.refresh();
                return;
            }
        }
    }

    private void addSpell(ItemStack stack, Spell spell) {
        for (int i = 0; i < SLOT_COUNT; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            ItemStack stackInSlot = slot.m_7993_();
            if (!stackInSlot.m_41619_() && !spell.equals(SpellHelper.getSpell(stackInSlot))) continue;
            stack.m_41774_(1);
            SpellHelper.addSpell(this.book, spell);
            this.refresh();
            return;
        }
    }

    private static class ScrollSlot
    extends Slot {
        public ScrollSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_150930_((Item)ECItems.SCROLL.get()) && this.m_7993_().m_41619_();
        }

        public int m_6641_() {
            return (Integer)ECConfig.COMMON.spellBookMaxSpell.get();
        }
    }
}

