/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;

public class FireInfusionLootModifier
extends LootModifier {
    public static final Codec<FireInfusionLootModifier> DIRECT_CODEC = RecordCodecBuilder.create(i -> FireInfusionLootModifier.codecStart((RecordCodecBuilder.Instance)i).apply((Applicative)i, FireInfusionLootModifier::new));
    private static final LootItemFunction FORTUNE = ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_).m_7453_();

    protected FireInfusionLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    private ItemStack applyAutoSmelt(ItemStack stack, LootContext context) {
        Optional<SmeltingRecipe> recipe = context.m_78952_().m_7465_().m_44054_(RecipeType.f_44108_).values().stream().filter(r -> ((Ingredient)r.m_7527_().get(0)).test(stack)).findFirst();
        if (recipe.isPresent()) {
            ItemStack ret = recipe.get().m_8043_().m_41777_();
            ret.m_41764_(ret.m_41613_() * stack.m_41613_());
            if (stack.m_204117_(Tags.Items.ORES)) {
                FORTUNE.apply((Object)ret, (Object)context);
            }
            return ret;
        }
        return stack;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        if (tool != null && !tool.m_41619_() && ToolInfusionHelper.hasAutoSmelt(tool)) {
            return generatedLoot.stream().map(s -> this.applyAutoSmelt((ItemStack)s, context)).collect(Collectors.toCollection(ObjectArrayList::new));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return DIRECT_CODEC;
    }
}

