/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.loot.function;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.loot.function.ECLootFunctions;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;

public class RandomSpell
extends LootItemConditionalFunction {
    private ElementType elementType;
    private final List<Spell> spellList;

    private RandomSpell(LootItemCondition[] condition, Collection<Spell> spellList) {
        super(condition);
        this.spellList = List.copyOf(spellList);
        this.elementType = ElementType.NONE;
    }

    private RandomSpell(LootItemCondition[] condition, ElementType elementType) {
        this(condition, List.of());
        this.elementType = elementType;
    }

    @Nonnull
    public ItemStack m_7372_(@Nonnull ItemStack stack, LootContext context) {
        RandomSource random = context.m_230907_();
        Spell spell = !this.spellList.isEmpty() ? SpellHelper.randomSpell(this.spellList, random) : (this.elementType != ElementType.NONE ? SpellHelper.randomSpell(this.elementType, random) : SpellHelper.randomSpell(random));
        SpellHelper.setSpell(stack, spell);
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return RandomSpell.builder(List.of());
    }

    public static LootItemConditionalFunction.Builder<?> builder(Collection<Spell> spellList) {
        return RandomSpell.m_80683_(l -> new RandomSpell((LootItemCondition[])l, spellList));
    }

    public static LootItemConditionalFunction.Builder<?> builder(ElementType elementType) {
        return RandomSpell.m_80683_(l -> new RandomSpell((LootItemCondition[])l, elementType));
    }

    @Nonnull
    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ECLootFunctions.RANDOM_SPELL.get();
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomSpell> {
        public void serialize(@Nonnull JsonObject object, @Nonnull RandomSpell function, @Nonnull JsonSerializationContext serializationContext) {
            super.m_6170_(object, (LootItemConditionalFunction)function, serializationContext);
            if (!function.spellList.isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (Spell spell : function.spellList) {
                    ResourceLocation resourcelocation = Spells.REGISTRY.get().getKey((Object)spell);
                    if (resourcelocation == null) {
                        throw new IllegalArgumentException("Don't know how to serialize spell " + spell);
                    }
                    jsonarray.add((JsonElement)new JsonPrimitive(resourcelocation.toString()));
                }
                object.add("spell_list", (JsonElement)jsonarray);
            } else if (function.elementType != ElementType.NONE) {
                object.addProperty("element_type", function.elementType.m_7912_());
            }
        }

        @Nonnull
        public RandomSpell deserialize(JsonObject object, @Nonnull JsonDeserializationContext deserializationContext, @Nonnull LootItemCondition[] conditionsIn) {
            ArrayList list = Lists.newArrayList();
            if (object.has("spell_list")) {
                for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)object, (String)"spell_list")) {
                    String s = GsonHelper.m_13805_((JsonElement)jsonelement, (String)"spell");
                    Spell spell = (Spell)Spells.REGISTRY.get().getValue(new ResourceLocation(s));
                    if (spell == null) {
                        throw new JsonSyntaxException("Unknown spell '" + s + "'");
                    }
                    list.add(spell);
                }
                return new RandomSpell(conditionsIn, list);
            }
            if (object.has("element_type")) {
                return new RandomSpell(conditionsIn, ElementType.byName(GsonHelper.m_13906_((JsonObject)object, (String)"element_type")));
            }
            return new RandomSpell(conditionsIn, list);
        }
    }
}

