/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.particle;

import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.particle.ECParticles;
import sirttas.elementalcraft.particle.element.ElementTypeParticleData;

public class ParticleHelper {
    private ParticleHelper() {
    }

    public static void createSourceParticle(ElementType type, Level level, Vec3 pos, RandomSource rand) {
        double x = pos.m_7096_() + (rand.m_188500_() * 2.0 - 1.0) / 16.0;
        double y = pos.m_7098_() - 0.1875;
        double z = pos.m_7094_() + (rand.m_188500_() * 2.0 - 1.0) / 16.0;
        ParticleHelper.addParticle(level, new ElementTypeParticleData((ParticleType<ElementTypeParticleData>)((ParticleType)ECParticles.SOURCE.get()), type), x, y, z, 0.0, 0.0, 0.0);
    }

    public static void createCraftingParticle(ElementType type, Level level, Vec3 pos, RandomSource rand) {
        double x = pos.m_7096_() + (rand.m_188500_() * 2.0 - 1.0) / 16.0;
        double y = pos.m_7098_() - 0.1875;
        double z = pos.m_7094_() + (rand.m_188500_() * 2.0 - 1.0) / 16.0;
        IntStream.range(0, 8 + rand.m_188503_(5)).forEach(i -> ParticleHelper.addParticle(level, new ElementTypeParticleData((ParticleType<ElementTypeParticleData>)((ParticleType)ECParticles.ELEMENT_CRAFTING.get()), type != ElementType.NONE ? type : ElementType.random(rand)), x, y, z, 0.0, 0.0, 0.0));
    }

    public static void createElementFlowParticle(ElementType type, Level level, Vec3 end, Direction direction, float scale, RandomSource rand) {
        ParticleHelper.createElementFlowParticle(type, level, end, Vec3.m_82528_((Vec3i)direction.m_122424_().m_122436_()).m_82490_(scale <= 0.0f ? 1.0 : (double)scale), new Vec3(3.0, 3.0, 3.0), rand);
    }

    public static void createElementFlowParticle(ElementType type, Level level, Vec3 start, Vec3 end, RandomSource rand) {
        ParticleHelper.createElementFlowParticle(type, level, end, start.m_82546_(end), new Vec3(1.0, 1.0, 1.0), rand);
    }

    private static void createElementFlowParticle(ElementType type, Level level, Vec3 end, Vec3 flow, Vec3 radius, RandomSource rand) {
        double x = end.m_7096_() + (2.0 * rand.m_188500_() - 1.0) * radius.m_7096_() / 16.0;
        double y = end.m_7098_() + (2.0 * rand.m_188500_() - 1.0) * radius.m_7098_() / 16.0;
        double z = end.m_7094_() + (2.0 * rand.m_188500_() - 1.0) * radius.m_7094_() / 16.0;
        ParticleHelper.addParticle(level, new ElementTypeParticleData((ParticleType<ElementTypeParticleData>)((ParticleType)ECParticles.ELEMENT_FLOW.get()), type), x, y, z, flow.m_7096_(), flow.m_7098_(), flow.m_7094_());
    }

    public static void createEnderParticle(Level level, Vec3 pos, int count, RandomSource rand) {
        for (int i = 0; i < count; ++i) {
            int j = rand.m_188503_(2) * 2 - 1;
            int k = rand.m_188503_(2) * 2 - 1;
            double d0 = pos.m_7096_() + 0.5 + 0.25 * (double)j;
            double d1 = pos.m_7098_() + (double)rand.m_188501_();
            double d2 = pos.m_7094_() + 0.5 + 0.25 * (double)k;
            double d3 = rand.m_188501_() * (float)j;
            double d4 = ((double)rand.m_188501_() - 0.5) * 0.125;
            double d5 = rand.m_188501_() * (float)k;
            ParticleHelper.addParticle(level, (ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void createItemBreakParticle(Level level, Vec3 pos, RandomSource rand, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 speed = new Vec3(0.0, rand.m_188500_() * 0.1 + 0.1, 0.0);
            Vec3 loc = pos.m_82520_(0.0, rand.m_188500_() * 0.2 - 0.2, 0.0);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), loc.f_82479_, loc.f_82480_, loc.f_82481_, 1, speed.f_82479_, speed.f_82480_ + 0.05, speed.f_82481_, 0.0);
                continue;
            }
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), loc.f_82479_, loc.f_82480_, loc.f_82481_, speed.f_82479_, speed.f_82480_ + 0.05, speed.f_82481_);
        }
    }

    private static void addParticle(Level level, ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_(particleData, x, y, z, 0, xSpeed, ySpeed, zSpeed, 1.0);
        } else {
            level.m_7106_(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

